/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Map;
import net.java.ao.RawEntity;
import net.java.ao.schema.TableNameConverter;

public final class CachingTableNameConverter
implements TableNameConverter {
    private final Map<Class<? extends RawEntity<?>>, String> cache;

    public CachingTableNameConverter(final TableNameConverter delegateTableNameConverter) {
        Preconditions.checkNotNull((Object)delegateTableNameConverter);
        this.cache = new MapMaker().makeComputingMap(new Function<Class<? extends RawEntity<?>>, String>(){

            public String apply(Class<? extends RawEntity<?>> entityClass) {
                return delegateTableNameConverter.getName(entityClass);
            }
        });
    }

    @Override
    public String getName(Class<? extends RawEntity<?>> entityClass) {
        return this.cache.get(entityClass);
    }
}

