/*
 * Copyright 2007 Daniel Spiewak
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.java.ao.schema;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Tags a specific method as representing a field who's value should be
 * auto-generated by the database in some sort of numeric sequence
 * (usually ascending order).  Not all databases support this function
 * as a field modifier.  For example, PostgreSQL requires the use of the
 * <code>SERIAL</code> type.  Thus, this annotation imposes priority
 * over the defined type and should <i>only</i> be used on <code>int</code>
 * or <code>long</code> fields (<code>short</code> is also acceptable if
 * great care is taken).</p>
 * 
 * <p>For databases which really have no way of supporting this exact
 * functionality (like Oracle), implementation may be omitted as long as
 * the 90% case is still covered.  For example, the Oracle implementation
 * of this property relies on the fact that PRIMARY KEY fields are already
 * auto-generated if no value is specified.</p>
 * 
 * <p>This annotation is only relevant to migrations.  It has no effect upon
 * "runtime" entity usage.</p>
 * 
 * @author Daniel Spiewak
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface AutoIncrement {}
