/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.java.ao.Common;
import net.java.ao.DisposableDataSource;
import net.java.ao.db.DerbyDatabaseProvider;

public class EmbeddedDerbyDatabaseProvider
extends DerbyDatabaseProvider {
    private final String uri;

    public EmbeddedDerbyDatabaseProvider(DisposableDataSource dataSource, String uri) {
        super(dataSource);
        this.uri = (String)Preconditions.checkNotNull((Object)uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void dispose() {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.uri + ";shutdown=true");
        }
        catch (SQLException sQLException) {
            Common.closeQuietly(conn);
            catch (Throwable throwable) {
                Common.closeQuietly(conn);
                throw throwable;
            }
        }
        Common.closeQuietly(conn);
        super.dispose();
    }
}

