/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import net.java.ao.DelegateConnection;

final class DelegateConnectionHandler
implements InvocationHandler {
    private final Connection delegate;
    private boolean closeable;

    private DelegateConnectionHandler(Connection delegate) {
        this.delegate = (Connection)Preconditions.checkNotNull((Object)delegate);
        this.closeable = true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (DelegateConnectionHandler.isSetCloseableMethod(method)) {
            this.setCloseable((Boolean)args[0]);
            return Void.TYPE;
        }
        if (DelegateConnectionHandler.isIsCloseableMethod(method)) {
            return this.isCloseable();
        }
        if (DelegateConnectionHandler.isCloseMethod(method)) {
            this.close();
            return Void.TYPE;
        }
        if (DelegateConnectionHandler.isIsClosedMethod(method)) {
            return this.isClosed();
        }
        return this.delegate(method, args);
    }

    private void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    private boolean isCloseable() {
        return this.closeable;
    }

    private void close() throws SQLException {
        if (this.isCloseable()) {
            this.delegate.close();
        }
    }

    private boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    private Object delegate(Method method, Object[] args) throws NoSuchMethodException, IllegalAccessException, Throwable {
        Method m = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
        m.setAccessible(true);
        try {
            return m.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static DelegateConnection newInstance(Connection c) {
        return (DelegateConnection)Proxy.newProxyInstance(DelegateConnectionHandler.class.getClassLoader(), new Class[]{DelegateConnection.class}, (InvocationHandler)new DelegateConnectionHandler(c));
    }

    private static boolean isSetCloseableMethod(Method method) {
        return method.getName().equals("setCloseable") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Boolean.TYPE);
    }

    private static boolean isIsCloseableMethod(Method method) {
        return method.getName().equals("isCloseable") && method.getParameterTypes().length == 0;
    }

    private static boolean isCloseMethod(Method method) {
        return method.getName().equals("close") && method.getParameterTypes().length == 0;
    }

    private static boolean isIsClosedMethod(Method method) {
        return method.getName().equals("isClosed") && method.getParameterTypes().length == 0;
    }
}

