/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntUniformRange;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import jasima.shopSim.util.modelDef.streams.IntStreamDef;
import java.util.List;

public class IntUniformDef
extends IntStreamDef {
    private static final long serialVersionUID = 741813233923786283L;
    public static final String PARAM_MAX_VALUE = "maxValue";
    public static final String PARAM_MIN_VALUE = "minValue";
    public static final String TYPE_STRING = "intUnif";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return IntUniformDef.TYPE_STRING;
        }

        @Override
        public IntUniformDef stringToStreamDef(String params, List<String> errors) {
            int[] ll;
            try {
                ll = Util.parseIntList(params);
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            if (ll.length != 2) {
                errors.add(I18n.defFormat("invalid number of parameters (2 required, min and max value): '%s'", params));
                return null;
            }
            IntUniformDef res = new IntUniformDef();
            res.setMinValue(ll[0]);
            res.setMaxValue(ll[1]);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            if (stream instanceof IntUniformRange) {
                IntUniformRange s = (IntUniformRange)stream;
                IntUniformDef def = new IntUniformDef();
                def.setMinValue(s.getMin());
                def.setMaxValue(s.getMax());
                return def;
            }
            return null;
        }
    };
    private int minValue = 0;
    private int maxValue = 10;

    public IntUniformDef() {
    }

    public IntUniformDef(int min, int max) {
        this();
        this.setMinValue(min);
        this.setMaxValue(max);
    }

    public String toString() {
        return I18n.defFormat("%s(%d,%d)", FACTORY.getTypeString(), this.getMinValue(), this.getMaxValue());
    }

    @Override
    public DblSequence createStream() {
        return new IntUniformRange(this.getMinValue(), this.getMaxValue());
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.firePropertyChange(PARAM_MIN_VALUE, this.minValue, this.minValue);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.firePropertyChange(PARAM_MAX_VALUE, this.maxValue, this.maxValue);
    }

    static {
        IntUniformDef.registerStreamFactory(FACTORY);
    }
}

