/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntEmpirical;
import jasima.core.util.Pair;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import jasima.shopSim.util.modelDef.streams.IntStreamDef;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class IntEmpDef
extends IntStreamDef {
    private static final long serialVersionUID = 6302098802706171687L;
    public static final String PARAM_PROBS = "probs";
    public static final String PARAM_VALUES = "values";
    public static final String TYPE_STRING = "intEmp";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return IntEmpDef.TYPE_STRING;
        }

        @Override
        public IntEmpDef stringToStreamDef(String params, List<String> errors) {
            ArrayList<Pair<Integer, Double>> l = new ArrayList<Pair<Integer, Double>>();
            StringTokenizer st = new StringTokenizer(params, "<");
            try {
                while (st.hasMoreTokens()) {
                    String v = st.nextToken().replace(">", "").trim();
                    String[] vv = v.split(",");
                    int v1 = Integer.parseInt(vv[0]);
                    double p1 = Double.parseDouble(vv[1]);
                    l.add(new Pair<Integer, Double>(v1, p1));
                }
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            double[] probs = new double[l.size()];
            int[] values = new int[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Pair p = (Pair)l.get(i);
                values[i] = (Integer)p.a;
                probs[i] = (Double)p.b;
            }
            if (Math.abs(Util.sum(probs) - 1.0) > 1.0E-6) {
                errors.add(I18n.defFormat("probabilities have to sum to 1.0, current sum is %f.", Util.sum(probs)));
                return null;
            }
            IntEmpDef res = new IntEmpDef();
            res.setProbs(probs);
            res.setValues(values);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            if (stream instanceof IntEmpirical) {
                IntEmpirical s = (IntEmpirical)stream;
                IntEmpDef def = new IntEmpDef();
                double[] probs = s.getProbabilities();
                if (probs != null) {
                    probs = (double[])probs.clone();
                }
                def.setProbs(probs);
                int[] values = s.getValues();
                if (values != null) {
                    values = (int[])values.clone();
                }
                def.setValues(values);
                return def;
            }
            return null;
        }
    };
    private double[] probs = new double[]{0.7, 0.3};
    private int[] values = new int[]{1, 2};

    public String toString() {
        String params = "";
        StringBuilder sb = new StringBuilder();
        int n = this.probs != null ? this.probs.length : 0;
        int m = this.values != null ? this.values.length : 0;
        for (int i = 0; i < Math.max(n, m); ++i) {
            String v = this.values != null && i < this.values.length ? Integer.toString(this.values[i]) : "?";
            String p = this.probs != null && i < this.probs.length ? Double.toString(this.probs[i]) : "?";
            sb.append('<').append(v).append(',').append(p).append(">;");
        }
        if (sb.length() > 0) {
            params = sb.substring(0, sb.length() - 1);
        }
        return I18n.defFormat("%s(%s)", FACTORY.getTypeString(), params);
    }

    @Override
    public IntEmpDef clone() {
        IntEmpDef c = (IntEmpDef)super.clone();
        if (this.values != null) {
            c.values = (int[])this.values.clone();
        }
        if (this.probs != null) {
            c.probs = (double[])this.probs.clone();
        }
        return c;
    }

    @Override
    public DblSequence createStream() {
        return new IntEmpirical((double[])this.getProbs().clone(), (int[])this.getValues().clone());
    }

    public double[] getProbs() {
        return this.probs;
    }

    public void setProbs(double[] probs) {
        this.probs = probs;
        this.firePropertyChange(PARAM_PROBS, this.probs, probs);
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] values) {
        this.values = values;
        this.firePropertyChange(PARAM_VALUES, this.values, values);
    }

    static {
        IntEmpDef.registerStreamFactory(FACTORY);
    }
}

