/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntConst;
import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import jasima.shopSim.util.modelDef.streams.IntStreamDef;
import java.util.Arrays;
import java.util.List;

public class IntConstDef
extends IntStreamDef {
    private static final long serialVersionUID = -4870221883421631767L;
    public static final String PARAM_VALUES = "values";
    public static final String TYPE_STRING = "intConst";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return IntConstDef.TYPE_STRING;
        }

        @Override
        public IntConstDef stringToStreamDef(String params, List<String> errors) {
            int[] ll;
            try {
                ll = Util.parseIntList(params);
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            IntConstDef res = new IntConstDef();
            res.setValues(ll);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            if (stream instanceof IntConst) {
                IntConst s = (IntConst)stream;
                IntConstDef def = new IntConstDef();
                int[] values = s.getValues();
                if (values != null) {
                    values = (int[])values.clone();
                }
                def.setValues(values);
                return def;
            }
            return null;
        }
    };
    private int[] values = new int[]{1, 2, 3};

    public String toString() {
        String s = Arrays.toString(this.getValues()).replace("[", "").replace("]", "");
        return I18n.defFormat("%s(%s)", FACTORY.getTypeString(), s);
    }

    @Override
    public IntSequence createStream() {
        return new IntConst(this.getValues() != null ? (int[])this.getValues().clone() : null);
    }

    @Override
    public IntConstDef clone() {
        IntConstDef c = (IntConstDef)super.clone();
        if (this.values != null) {
            c.values = (int[])this.values.clone();
        }
        return c;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] values) {
        this.values = values;
        this.firePropertyChange(PARAM_VALUES, this.values, values);
    }

    static {
        IntConstDef.registerStreamFactory(FACTORY);
    }
}

