/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.continuous.DblUniformRange;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import java.util.List;

public class DblUniformDef
extends DblStreamDef {
    private static final long serialVersionUID = -586246159696640227L;
    public static final String PARAM_MAX_VALUE = "maxValue";
    public static final String PARAM_MIN_VALUE = "minValue";
    public static final String TYPE_STRING = "dblUnif";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return DblUniformDef.TYPE_STRING;
        }

        @Override
        public DblUniformDef stringToStreamDef(String params, List<String> errors) {
            double[] ll;
            try {
                ll = Util.parseDblList(params);
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            if (ll.length != 2) {
                errors.add(I18n.defFormat("invalid number of parameters (2 required, min and max value): '%s'", params));
                return null;
            }
            DblUniformDef res = new DblUniformDef();
            res.setMinValue(ll[0]);
            res.setMaxValue(ll[1]);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            if (stream instanceof DblUniformRange) {
                DblUniformRange s = (DblUniformRange)stream;
                DblUniformDef def = new DblUniformDef();
                def.setMinValue(s.getMin());
                def.setMaxValue(s.getMax());
                return def;
            }
            return null;
        }
    };
    private double minValue = 0.0;
    private double maxValue = 1.0;

    public String toString() {
        return I18n.defFormat("%s(%s,%s)", FACTORY.getTypeString(), this.getMinValue(), this.getMaxValue());
    }

    @Override
    public DblSequence createStream() {
        return new DblUniformRange(this.getMinValue(), this.getMaxValue());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        this.firePropertyChange(PARAM_MIN_VALUE, this.minValue, this.minValue);
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.firePropertyChange(PARAM_MAX_VALUE, this.maxValue, this.maxValue);
    }

    static {
        DblUniformDef.registerStreamFactory(FACTORY);
    }
}

