/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.continuous.DblTriangular;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import java.util.List;
import java.util.Locale;

public class DblTriangularDef
extends DblStreamDef {
    private static final long serialVersionUID = 2748975328234554477L;
    public static final String PARAM_MAX_VALUE = "maxValue";
    public static final String PARAM_MODE_VALUE = "modeValue";
    public static final String PARAM_MIN_VALUE = "minValue";
    public static final String TYPE_STRING = "dblTri";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return DblTriangularDef.TYPE_STRING;
        }

        @Override
        public DblTriangularDef stringToStreamDef(String params, List<String> errors) {
            double[] ll;
            try {
                ll = Util.parseDblList(params);
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            if (ll.length != 3) {
                errors.add(I18n.defFormat("invalid number of parameters (3 required, min, mode, and max value): '%s'", params));
                return null;
            }
            DblTriangularDef res = new DblTriangularDef();
            res.setMinValue(ll[0]);
            res.setModeValue(ll[1]);
            res.setMaxValue(ll[2]);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            if (stream instanceof DblTriangular) {
                DblTriangular s = (DblTriangular)stream;
                DblTriangularDef def = new DblTriangularDef();
                def.setMinValue(s.getMin());
                def.setModeValue(s.getMode());
                def.setMaxValue(s.getMax());
                return def;
            }
            return null;
        }
    };
    private double minValue = 0.0;
    private double modeValue = 5.0;
    private double maxValue = 10.0;

    public String toString() {
        return String.format(Locale.US, "%s(%s,%s,%s)", FACTORY.getTypeString(), this.getMinValue(), this.getModeValue(), this.getMaxValue());
    }

    @Override
    public DblSequence createStream() {
        return new DblTriangular(this.getMinValue(), this.getModeValue(), this.getMaxValue());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        this.firePropertyChange(PARAM_MIN_VALUE, this.minValue, this.minValue);
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.firePropertyChange(PARAM_MAX_VALUE, this.maxValue, this.maxValue);
    }

    public double getModeValue() {
        return this.modeValue;
    }

    public void setModeValue(double modeValue) {
        this.modeValue = modeValue;
        this.firePropertyChange(PARAM_MODE_VALUE, this.modeValue, this.modeValue);
    }

    static {
        DblTriangularDef.registerStreamFactory(FACTORY);
    }
}

