/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.PropertySupport;
import jasima.shopSim.util.modelDef.streams.DblConstDef;
import jasima.shopSim.util.modelDef.streams.DblExponentialDef;
import jasima.shopSim.util.modelDef.streams.DblTriangularDef;
import jasima.shopSim.util.modelDef.streams.DblUniformDef;
import jasima.shopSim.util.modelDef.streams.IntConstDef;
import jasima.shopSim.util.modelDef.streams.IntEmpDef;
import jasima.shopSim.util.modelDef.streams.IntUniformDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public abstract class DblStreamDef
extends PropertySupport {
    private static final long serialVersionUID = -3013662965159027666L;
    private static HashMap<String, StreamDefFact> streamFactoryReg = new HashMap();

    public abstract DblSequence createStream();

    public static DblStreamDef parseDblStream(String s, List<String> errors) {
        StringTokenizer sst = new StringTokenizer(s, "()", false);
        ArrayList<String> ss = new ArrayList<String>();
        while (sst.hasMoreTokens()) {
            ss.add(sst.nextToken().trim());
        }
        if (ss.size() != 2) {
            errors.add("invalid stream configuration '" + s + "'");
            return null;
        }
        String type = (String)ss.get(0);
        String parms = (String)ss.get(1);
        StreamDefFact fact = streamFactoryReg.get(type);
        if (fact == null) {
            errors.add(I18n.defFormat("Invalid stream type '%s'. Supported types are: '%s'.", type, streamFactoryReg.keySet().toString().replaceAll("[\\[\\]]", "")));
            return null;
        }
        DblStreamDef res = fact.stringToStreamDef(parms, errors);
        return res;
    }

    public static DblStreamDef createStreamDefFromStream(DblSequence stream) {
        for (StreamDefFact fact : streamFactoryReg.values()) {
            DblStreamDef sd = fact.streamToStreamDef(stream);
            if (sd == null) continue;
            return sd;
        }
        return null;
    }

    @Override
    public DblStreamDef clone() {
        return (DblStreamDef)super.clone();
    }

    public static void registerStreamFactory(StreamDefFact fact) {
        streamFactoryReg.put(fact.getTypeString(), fact);
    }

    static {
        new DblConstDef();
        new DblExponentialDef();
        new DblUniformDef();
        new DblTriangularDef();
        new IntUniformDef();
        new IntEmpDef();
        new IntConstDef();
    }

    public static interface StreamDefFact {
        public String getTypeString();

        public DblStreamDef stringToStreamDef(String var1, List<String> var2);

        public DblStreamDef streamToStreamDef(DblSequence var1);
    }
}

