/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.random.continuous.DblSequence;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import java.util.List;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class DblExponentialDef
extends DblStreamDef {
    private static final long serialVersionUID = 332888720647354355L;
    public static final String PARAM_MEAN = "mean";
    public static final String TYPE_STRING = "dblExp";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return DblExponentialDef.TYPE_STRING;
        }

        @Override
        public DblExponentialDef stringToStreamDef(String params, List<String> errors) {
            double d;
            try {
                d = Double.parseDouble(params);
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            DblExponentialDef res = new DblExponentialDef();
            res.setMean(d);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            DblDistribution s;
            if (stream instanceof DblDistribution && (s = (DblDistribution)stream).getDistribution() instanceof ExponentialDistribution) {
                ExponentialDistribution dist = (ExponentialDistribution)s.getDistribution();
                DblExponentialDef def = new DblExponentialDef();
                def.setMean(dist.getMean());
                return def;
            }
            return null;
        }
    };
    private double mean = 1.0;

    public String toString() {
        return I18n.defFormat("%s(%s)", FACTORY.getTypeString(), this.getMean());
    }

    @Override
    public DblSequence createStream() {
        return new DblDistribution((RealDistribution)new ExponentialDistribution(this.getMean()));
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
        this.firePropertyChange(PARAM_MEAN, this.mean, this.mean);
    }

    static {
        DblExponentialDef.registerStreamFactory(FACTORY);
    }
}

