/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef.streams;

import jasima.core.random.continuous.DblConst;
import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import java.util.Arrays;
import java.util.List;

public class DblConstDef
extends DblStreamDef {
    private static final long serialVersionUID = -2859329292507063575L;
    public static final String PARAM_VALUES = "values";
    public static final String TYPE_STRING = "const";
    public static final DblStreamDef.StreamDefFact FACTORY = new DblStreamDef.StreamDefFact(){

        @Override
        public String getTypeString() {
            return DblConstDef.TYPE_STRING;
        }

        @Override
        public DblConstDef stringToStreamDef(String params, List<String> errors) {
            double[] ll;
            try {
                ll = Util.parseDblList(params);
            }
            catch (NumberFormatException nfe) {
                errors.add(I18n.defFormat("invalid number: %s", nfe.getLocalizedMessage()));
                return null;
            }
            DblConstDef res = new DblConstDef();
            res.setValues(ll);
            return res;
        }

        @Override
        public DblStreamDef streamToStreamDef(DblSequence stream) {
            if (stream instanceof DblConst) {
                DblConst s = (DblConst)stream;
                DblConstDef def = new DblConstDef();
                double[] values = s.getValues();
                if (values != null) {
                    values = (double[])values.clone();
                }
                def.setValues(values);
                return def;
            }
            return null;
        }
    };
    private double[] values = new double[]{1.0, 2.0, 3.0};

    public String toString() {
        String s = Arrays.toString(this.getValues()).replace("[", "").replace("]", "");
        return I18n.defFormat("%s(%s)", FACTORY.getTypeString(), s);
    }

    @Override
    public DblConstDef clone() {
        DblConstDef c = (DblConstDef)super.clone();
        if (this.values != null) {
            c.values = (double[])this.values.clone();
        }
        return c;
    }

    @Override
    public DblSequence createStream() {
        return new DblConst(this.getValues() != null ? (double[])this.getValues().clone() : null);
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
        this.firePropertyChange(PARAM_VALUES, this.values, values);
    }

    static {
        DblConstDef.registerStreamFactory(FACTORY);
    }
}

