/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util.modelDef;

import jasima.core.util.TypeUtil;
import jasima.shopSim.util.ShopConfigurator;
import jasima.shopSim.util.modelDef.PropertySupport;
import jasima.shopSim.util.modelDef.RouteDef;
import jasima.shopSim.util.modelDef.SourceDef;
import jasima.shopSim.util.modelDef.WorkstationDef;

public class ShopDef
extends PropertySupport
implements Cloneable {
    private static final long serialVersionUID = -8471081132120093539L;
    private String name = null;
    private double simulationLength = Double.NaN;
    private int maxJobsInSystem = 0;
    private int stopAfterNumJobs = 0;
    private boolean enableLookAhead = false;
    private WorkstationDef[] workstations = new WorkstationDef[0];
    private SourceDef[] jobSources = new SourceDef[0];
    private RouteDef[] routes = new RouteDef[0];

    public double getSimulationLength() {
        return this.simulationLength;
    }

    public void setSimulationLength(double simulationLength) {
        this.simulationLength = simulationLength;
        this.firePropertyChange("simulationLength", this.simulationLength, this.simulationLength);
    }

    public int getMaxJobsInSystem() {
        return this.maxJobsInSystem;
    }

    public void setMaxJobsInSystem(int maxJobsInSystem) {
        this.maxJobsInSystem = maxJobsInSystem;
        this.firePropertyChange("maxJobsInSystem", this.maxJobsInSystem, this.maxJobsInSystem);
    }

    public int getStopAfterNumJobs() {
        return this.stopAfterNumJobs;
    }

    public void setStopAfterNumJobs(int stopAfterNumJobs) {
        this.stopAfterNumJobs = stopAfterNumJobs;
        this.firePropertyChange("stopAfterNumJobs", this.stopAfterNumJobs, this.stopAfterNumJobs);
    }

    public boolean isEnableLookAhead() {
        return this.enableLookAhead;
    }

    public void setEnableLookAhead(boolean enableLookAhead) {
        this.enableLookAhead = enableLookAhead;
        this.firePropertyChange("enableLookAhead", this.enableLookAhead, this.enableLookAhead);
    }

    public WorkstationDef[] getWorkstations() {
        return this.workstations;
    }

    public void setWorkstations(WorkstationDef[] workstations) {
        this.workstations = workstations;
        this.firePropertyChange("workstations", this.workstations, workstations);
    }

    public SourceDef[] getJobSources() {
        return this.jobSources;
    }

    public void setJobSources(SourceDef[] js) {
        this.jobSources = js;
        this.firePropertyChange("jobSources", this.jobSources, js);
    }

    public RouteDef[] getRoutes() {
        return this.routes;
    }

    public void setRoutes(RouteDef[] rs) {
        if (rs != null) {
            for (RouteDef m : rs) {
                m.setShop(this);
            }
        }
        if (this.routes != null) {
            for (RouteDef m : this.routes) {
                m.setShop(null);
            }
        }
        this.routes = rs;
        this.firePropertyChange("routes", this.routes, rs);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    public ShopConfigurator getShopConfigurator() {
        ShopConfigurator conf = new ShopConfigurator();
        conf.setShopDef(this);
        return conf;
    }

    @Override
    public ShopDef clone() {
        ShopDef c = (ShopDef)super.clone();
        if (this.workstations != null) {
            c.workstations = TypeUtil.deepCloneArrayIfPossible(this.workstations);
        }
        if (this.jobSources != null) {
            c.jobSources = TypeUtil.deepCloneArrayIfPossible(this.jobSources);
        }
        if (this.routes != null) {
            c.routes = TypeUtil.deepCloneArrayIfPossible(this.routes);
        }
        return c;
    }
}

