/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util;

import jasima.core.util.Pair;
import jasima.core.util.Util;
import jasima.shopSim.util.modelDef.DynamicSourceDef;
import jasima.shopSim.util.modelDef.JobDef;
import jasima.shopSim.util.modelDef.OperationDef;
import jasima.shopSim.util.modelDef.RouteDef;
import jasima.shopSim.util.modelDef.ShopDef;
import jasima.shopSim.util.modelDef.SourceDef;
import jasima.shopSim.util.modelDef.StaticSourceDef;
import jasima.shopSim.util.modelDef.WorkstationDef;
import jasima.shopSim.util.modelDef.streams.DblStreamDef;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class TextFileReader {
    private static final String JOB_SECT_MARKER = "jobs";
    private static final String JOB_SECT_DYN_MARKER = "jobs_dynamic";
    private static final String NAME_MARKER = "machineName";
    private static final String SETUP_MATRIX_MARKER = "setup";
    private static final String NUM_IN_GROUP_MARKER = "numInGroup";
    private static final String MACHINE_RELEASE_MARKER = "machineReleaseDates";
    private static final String DEF_SETUP = "DEF_SETUP";
    private ShopDef data = null;
    private HashMap<String, Integer> machIds = new HashMap();
    private boolean haveData = false;

    public ShopDef getShopDef() {
        return this.haveData ? this.data : null;
    }

    public ShopDef readData(BufferedReader r) {
        this.data = new ShopDef();
        try {
            int numMachines = Integer.parseInt(Util.nextNonEmptyLine(r));
            WorkstationDef[] ws = new WorkstationDef[numMachines];
            for (int i = 0; i < numMachines; ++i) {
                WorkstationDef wd;
                ws[i] = wd = new WorkstationDef();
            }
            this.data.setWorkstations(ws);
            int numRoutes = Integer.parseInt(Util.nextNonEmptyLine(r));
            RouteDef[] rs = new RouteDef[numRoutes];
            for (int i = 0; i < numRoutes; ++i) {
                RouteDef rd;
                rs[i] = rd = new RouteDef();
            }
            this.data.setRoutes(rs);
            this.readMachOrderAndSetups(r);
            this.readProcTimesAndBatching(r);
            String s = this.readMachineParams(r);
            while (s != null) {
                s = this.readJobs(r, s);
            }
            this.haveData = true;
            return this.data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String readJobs(BufferedReader r, String s) throws IOException {
        if (JOB_SECT_MARKER.equalsIgnoreCase(s)) {
            s = this.readJobs(r);
        } else if (JOB_SECT_DYN_MARKER.equalsIgnoreCase(s)) {
            s = this.readDynJobs(r);
        } else {
            throw new IllegalArgumentException(s);
        }
        return s;
    }

    private void readMachOrderAndSetups(BufferedReader r) throws IOException {
        RouteDef[] routes = this.data.getRoutes();
        int numRoutes = routes.length;
        String[][] machTmp = Util.read2DimStrings(r, numRoutes);
        for (int i = 0; i < numRoutes; ++i) {
            RouteDef rd = routes[i];
            int numOps = machTmp[i].length;
            OperationDef[] ops = new OperationDef[numOps];
            rd.setOperations(ops);
            for (int j = 0; j < numOps; ++j) {
                OperationDef od;
                ops[j] = od = new OperationDef();
                String[] dat = machTmp[i][j].split(";");
                assert (dat.length > 0 && dat.length <= 2);
                od.setSetup(DEF_SETUP);
                if (dat.length == 2) {
                    od.setSetup(dat[1]);
                }
                String machId = dat[0];
                int idx = this.getMachIdx(machId);
                od.setWorkstation(idx);
            }
        }
    }

    private void readProcTimesAndBatching(BufferedReader r) throws IOException {
        RouteDef[] routes = this.data.getRoutes();
        int numRoutes = routes.length;
        String[][] tmp = Util.read2DimStrings(r, numRoutes);
        for (int i = 0; i < numRoutes; ++i) {
            RouteDef rd = routes[i];
            int numOps = tmp[i].length;
            OperationDef[] ops = rd.getOperations();
            for (int j = 0; j < numOps; ++j) {
                OperationDef od = ops[j];
                String[] dat = tmp[i][j].split(";");
                assert (dat.length == 1 || dat.length == 3);
                od.setProcTime(Double.parseDouble(dat[0]));
                od.setBatchFamily("BATCH_INCOMPATIBLE");
                od.setMaxBatchSize(1);
                if (dat.length != 3) continue;
                od.setBatchFamily(dat[1]);
                od.setMaxBatchSize(Integer.parseInt(dat[2]));
            }
        }
    }

    private int getMachIdx(String machId) {
        Integer idx = this.machIds.get(machId);
        if (idx == null) {
            try {
                idx = Integer.parseInt(machId) - 1;
            }
            catch (NumberFormatException ignore) {
                idx = this.machIds.size();
            }
            assert (!this.machIds.containsValue(idx));
            this.machIds.put(machId, idx);
        }
        return idx;
    }

    private String readJobs(BufferedReader r) throws IOException {
        String s = Util.nextNonEmptyLine(r);
        if (s == null) {
            return s;
        }
        int numRoutes = this.data.getRoutes().length;
        int numJobs = Integer.parseInt(s);
        JobDef[] jobs = new JobDef[numJobs];
        String[][] rawVals = Util.read2DimStrings(r, numJobs);
        for (int n = 0; n < rawVals.length; ++n) {
            String[] i = rawVals[n];
            int route = Integer.parseInt(i[0]);
            if (route < 1 || route > numRoutes) {
                throw new IllegalArgumentException("Invalid route number " + route);
            }
            double rel = Double.parseDouble(i[1]);
            double due = Double.parseDouble(i[2]);
            double w = Double.parseDouble(i[3]);
            String name = i.length >= 5 ? i[4] : null;
            RouteDef rd = this.data.getRoutes()[--route];
            jobs[n] = new JobDef(route, rel, due, w, name);
        }
        StaticSourceDef sd = new StaticSourceDef();
        sd.setJobSpecs(jobs);
        SourceDef[] as = Util.addToArray(this.data.getJobSources(), SourceDef.class, sd);
        this.data.setJobSources(as);
        return Util.nextNonEmptyLine(r);
    }

    private String readDynJobs(BufferedReader r) throws IOException {
        String s = Util.nextNonEmptyLine(r);
        if (s == null) {
            return s;
        }
        DblStreamDef iats = null;
        DblStreamDef dueDates = null;
        DblStreamDef weights = null;
        ArrayList<String> errors = new ArrayList<String>();
        if (!"route".equalsIgnoreCase(s)) {
            throw new RuntimeException("parse error '" + s + "'");
        }
        s = Util.nextNonEmptyLine(r);
        int rt = Integer.parseInt(s);
        if (rt < 1 || rt > this.data.getRoutes().length) {
            throw new RuntimeException("Invalid route number " + rt);
        }
        RouteDef route = this.data.getRoutes()[--rt];
        s = Util.nextNonEmptyLine(r);
        if (!"arrivals".equalsIgnoreCase(s)) {
            throw new RuntimeException("parse error '" + s + "'");
        }
        s = Util.nextNonEmptyLine(r);
        iats = DblStreamDef.parseDblStream(s, errors);
        if (errors.size() > 0) {
            throw new RuntimeException("parse error '" + s + "', " + Arrays.toString(errors.toArray()));
        }
        s = Util.nextNonEmptyLine(r);
        if (!"due_dates".equalsIgnoreCase(s)) {
            throw new RuntimeException("parse error '" + s + "'");
        }
        s = Util.nextNonEmptyLine(r);
        dueDates = DblStreamDef.parseDblStream(s, errors);
        if (errors.size() > 0) {
            throw new RuntimeException("parse error '" + s + "', " + Arrays.toString(errors.toArray()));
        }
        s = Util.nextNonEmptyLine(r);
        if (!"weights".equalsIgnoreCase(s)) {
            throw new RuntimeException("parse error '" + s + "'");
        }
        s = Util.nextNonEmptyLine(r);
        weights = DblStreamDef.parseDblStream(s, errors);
        if (errors.size() > 0) {
            throw new RuntimeException("parse error '" + s + "', " + Arrays.toString(errors.toArray()));
        }
        s = Util.nextNonEmptyLine(r);
        int numJobs = -1;
        if ("numJobs".equalsIgnoreCase(s)) {
            s = Util.nextNonEmptyLine(r);
            numJobs = Integer.parseInt(s);
            s = Util.nextNonEmptyLine(r);
        }
        DynamicSourceDef sd = new DynamicSourceDef();
        sd.setIats(iats);
        sd.setDueDates(dueDates);
        sd.setWeights(weights);
        sd.setRoute(rt);
        if (numJobs >= 0) {
            sd.setNumJobs(numJobs);
        }
        SourceDef[] as = Util.addToArray(this.data.getJobSources(), SourceDef.class, sd);
        this.data.setJobSources(as);
        return s;
    }

    private String readMachineParams(BufferedReader r) throws IOException {
        String sm = Util.nextNonEmptyLine(r);
        WorkstationDef ms = null;
        while (sm != null && !JOB_SECT_MARKER.equalsIgnoreCase(sm) && !JOB_SECT_DYN_MARKER.equalsIgnoreCase(sm)) {
            if (SETUP_MATRIX_MARKER.equals(sm)) {
                HashMap<Pair<String, String>, Double> matrix = TextFileReader.readSetupMatrix(r);
                ArrayList<String> states = new ArrayList<String>();
                states.add(DEF_SETUP);
                for (Pair p : matrix.keySet()) {
                    if (!states.contains(p.a)) {
                        states.add((String)p.a);
                    }
                    if (states.contains(p.b)) continue;
                    states.add((String)p.b);
                }
                double[][] times = new double[states.size()][states.size()];
                for (int i = 0; i < states.size(); ++i) {
                    String s1 = (String)states.get(i);
                    for (int j = 0; j < states.size(); ++j) {
                        String s2 = (String)states.get(j);
                        Double d = (Double)matrix.get(new Pair<String, String>(s1, s2));
                        times[i][j] = d == null ? 0.0 : d;
                    }
                }
                ms.setSetupStates(states.toArray(new String[states.size()]));
                ms.setSetupTimes(times);
            } else if (NAME_MARKER.equals(sm)) {
                String name = Util.nextNonEmptyLine(r);
                ms.setName(name);
            } else if (NUM_IN_GROUP_MARKER.equals(sm)) {
                int inGroup = Integer.parseInt(Util.nextNonEmptyLine(r));
                ms.setNumInGroup(inGroup);
            } else if (MACHINE_RELEASE_MARKER.equals(sm)) {
                String[] ss = Util.nextNonEmptyLine(r).trim().split("\\s+");
                if (ss.length != ms.getNumInGroup()) {
                    throw new IllegalArgumentException();
                }
                double[] rel = new double[ms.getNumInGroup()];
                for (int i = 0; i < ss.length; ++i) {
                    rel[i] = Double.parseDouble(ss[i]);
                }
                ms.setMachReleaseDates(rel);
            } else {
                int m = this.getMachIdx(sm.trim());
                ms = this.data.getWorkstations()[m];
            }
            sm = Util.nextNonEmptyLine(r);
        }
        return sm;
    }

    public static HashMap<Pair<String, String>, Double> readSetupMatrix(BufferedReader r) throws IOException {
        int numStates = Integer.parseInt(Util.nextNonEmptyLine(r));
        String[][] spec = Util.read2DimStrings(r, numStates);
        HashMap<Pair<String, String>, Double> matrix = new HashMap<Pair<String, String>, Double>();
        for (int n = 0; n < numStates; ++n) {
            for (int n2 = 0; n2 < numStates; ++n2) {
                Pair<String, String> pair = new Pair<String, String>(spec[n][0], spec[n2][0]);
                String s = spec[n][n2 + 1];
                double val = !"x".equalsIgnoreCase(s) ? Double.parseDouble(s) : 0.0;
                matrix.put(pair, val);
            }
        }
        return matrix;
    }
}

