/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util;

import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.Simulation;
import jasima.core.simulation.arrivalprocess.ArrivalsStationary;
import jasima.shopSim.core.DynamicJobSource;
import jasima.shopSim.core.IndividualMachine;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.JobSource;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.Route;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.StaticJobSource;
import jasima.shopSim.core.WorkStation;
import jasima.shopSim.util.modelDef.DynamicSourceDef;
import jasima.shopSim.util.modelDef.JobDef;
import jasima.shopSim.util.modelDef.OperationDef;
import jasima.shopSim.util.modelDef.RouteDef;
import jasima.shopSim.util.modelDef.ShopDef;
import jasima.shopSim.util.modelDef.SourceDef;
import jasima.shopSim.util.modelDef.StaticSourceDef;
import jasima.shopSim.util.modelDef.WorkstationDef;

public class ShopConfigurator {
    private ShopDef shopDef;

    public static void configureModel(Shop shop, ShopDef sd) {
        ShopConfigurator tfr = sd.getShopConfigurator();
        tfr.setShopDef(sd);
        tfr.configureMdl(shop);
    }

    public void configureSimulation(Simulation sim) {
        sim.setName(this.shopDef.getName());
        if (this.shopDef.getSimulationLength() >= 0.0) {
            sim.setSimulationLength(this.shopDef.getSimulationLength());
        }
    }

    public void configureMdl(Shop shop) {
        shop.setEnableLookAhead(this.shopDef.isEnableLookAhead());
        shop.setStopAfterNumJobs(this.shopDef.getStopAfterNumJobs());
        shop.setMaxJobsInSystem(this.shopDef.getMaxJobsInSystem());
        for (WorkstationDef wd : this.shopDef.getWorkstations()) {
            int i;
            int groupSize = wd.getNumInGroup();
            double[] rel = wd.getMachReleaseDates();
            String[] initialSetups = wd.getInitialSetups();
            WorkStation m = new WorkStation(groupSize);
            m.setName(wd.getName());
            shop.addMachine(m);
            if (wd.getSetupStates() != null) {
                i = 0;
                for (String s : wd.getSetupStates()) {
                    int idx = m.translateSetupState(s);
                    assert (i == idx);
                    ++i;
                }
                m.setSetupMatrix(wd.getSetupTimes());
            }
            for (i = 0; i < groupSize; ++i) {
                IndividualMachine im = m.machDat()[i];
                if (rel != null) {
                    im.relDate = rel[i];
                }
                String setup = initialSetups != null ? initialSetups[i] : "DEF_SETUP";
                im.initialSetup = m.translateSetupState(setup);
            }
        }
        int numRoutes = this.shopDef.getRoutes().length;
        Route[] routes = new Route[numRoutes];
        for (int i = 0; i < numRoutes; ++i) {
            Route r = new Route();
            RouteDef rd = this.shopDef.getRoutes()[i];
            this.initOperations(shop, r, rd);
            routes[i] = r;
        }
        shop.routes = routes;
        for (SourceDef sd : this.shopDef.getJobSources()) {
            JobSource s = null;
            s = sd instanceof StaticSourceDef ? this.createStaticSource((StaticSourceDef)sd) : this.createDynamicSource(shop, (DynamicSourceDef)sd);
            shop.addJobSource(s);
        }
    }

    private JobSource createDynamicSource(Shop shop, DynamicSourceDef sd) {
        int route = sd.getRoute();
        DblSequence iats = sd.getIats().createStream();
        DblSequence dueDates = sd.getDueDates().createStream();
        DblSequence weights = sd.getWeights().createStream();
        final int numJobs = sd.getNumJobs();
        DynamicJobSource ds = new DynamicJobSource(){
            private int numCreated;

            @Override
            public void init() {
                super.init();
                this.numCreated = 0;
            }

            @Override
            public Job createNextJob() {
                Job j = super.createNextJob();
                ++this.numCreated;
                if (numJobs > 0 && this.numCreated > numJobs) {
                    this.stopArrivals = true;
                }
                return j;
            }
        };
        ds.setRoute(shop.getRoutes()[route]);
        ArrivalsStationary arrivals = new ArrivalsStationary();
        arrivals.setArrivalAtTimeZero(false);
        arrivals.setInterArrivalTimes(iats.clone());
        ds.setArrivalProcess(arrivals);
        ds.setDueDateFactors(dueDates.clone());
        ds.setJobWeights(weights.clone());
        return ds;
    }

    private StaticJobSource createStaticSource(StaticSourceDef ssd) {
        StaticJobSource s = new StaticJobSource();
        JobDef[] jobDefs = ssd.getJobSpecs();
        StaticJobSource.JobSpec[] jss = new StaticJobSource.JobSpec[jobDefs.length];
        for (int i = 0; i < jobDefs.length; ++i) {
            StaticJobSource.JobSpec js;
            JobDef jd = jobDefs[i];
            jss[i] = js = new StaticJobSource.JobSpec(jd.getRoute(), jd.getReleaseDate(), jd.getDueDate(), jd.getWeight(), jd.getName());
        }
        s.jobs = jss;
        return s;
    }

    private void initOperations(Shop shop, Route r, RouteDef rd) {
        int numOps = rd.getOperations().length;
        for (int i = 0; i < numOps; ++i) {
            OperationDef od = rd.getOperations()[i];
            Operation o = new Operation();
            o.setMachine((WorkStation)shop.machines().getChild(od.getWorkstation()));
            o.setProcTime(od.getProcTime());
            o.setSetupState(o.getMachine().translateSetupState(od.getSetup()));
            o.setBatchFamily(od.getBatchFamily());
            o.setMaxBatchSize(od.getMaxBatchSize());
            r.addSequentialOperation(o);
        }
    }

    public ShopDef getShopDef() {
        return this.shopDef;
    }

    public void setShopDef(ShopDef shopDef) {
        this.shopDef = shopDef;
    }
}

