/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util;

import jasima.core.simulation.SimComponent;
import jasima.core.statistics.SummaryStat;
import jasima.core.statistics.TimeWeightedSummaryStat;
import jasima.shopSim.core.IndividualMachine;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.WorkStation;
import jasima.shopSim.core.WorkStationListener;
import java.util.Map;

public class MachineStatCollector
implements WorkStationListener,
Cloneable {
    public TimeWeightedSummaryStat aveMachinesBusy;
    public TimeWeightedSummaryStat aniq;
    public SummaryStat stationDelay;
    public SummaryStat capacityUtilized;
    public SummaryStat aveBatchSize;
    public SummaryStat setupTime;
    public SummaryStat procTime;

    @Override
    public void init(SimComponent c) {
        WorkStation m = (WorkStation)c;
        this.aveMachinesBusy = new TimeWeightedSummaryStat().value(m.numBusy(), m.shop().simTime());
        this.aniq = new TimeWeightedSummaryStat().value(m.numJobsWaiting(), m.shop().simTime());
        this.stationDelay = new SummaryStat();
        this.capacityUtilized = new SummaryStat();
        this.aveBatchSize = new SummaryStat();
        this.setupTime = new SummaryStat();
        this.procTime = new SummaryStat();
    }

    @Override
    public void produceResults(SimComponent c, Map<String, Object> res) {
        WorkStation m = (WorkStation)c;
        res.put(m.getName() + ".qLen", this.aniq);
        res.put(m.getName() + ".util", this.aveMachinesBusy);
        res.put(m.getName() + ".capUtil", this.capacityUtilized);
        res.put(m.getName() + ".bSize", this.aveBatchSize);
        res.put(m.getName() + ".setup", this.setupTime);
        res.put(m.getName() + ".qWait", this.stationDelay);
    }

    @Override
    public void done(SimComponent c) {
        WorkStation m = (WorkStation)c;
        this.aniq.value(Double.NaN, m.shop().simTime());
        this.aveMachinesBusy.value(Double.NaN, m.shop().simTime());
    }

    @Override
    public void arrival(WorkStation m, Job j) {
        if (!j.isFuture()) {
            this.aniq.value(m.numJobsWaiting(), m.shop().simTime());
        }
    }

    @Override
    public void activated(WorkStation m, IndividualMachine justActivated) {
        this.aveMachinesBusy.value(m.numBusy(), m.shop().simTime());
    }

    @Override
    public void operationStarted(WorkStation m, PrioRuleTarget jobOrBatch, int oldSetupState, int newSetupState, double setTime) {
        if (jobOrBatch == null) {
            return;
        }
        double simTime = m.shop().simTime();
        this.aveMachinesBusy.value(m.numBusy(), simTime);
        for (int i = 0; i < jobOrBatch.numJobsInBatch(); ++i) {
            this.stationDelay.value(simTime - jobOrBatch.job(i).getArriveTime());
        }
        Operation op = jobOrBatch.getCurrentOperation();
        this.capacityUtilized.value((double)jobOrBatch.numJobsInBatch() / (double)op.getMaxBatchSize());
        this.aveBatchSize.value(jobOrBatch.numJobsInBatch());
        this.aniq.value(m.numJobsWaiting(), simTime);
        this.setupTime.value(setTime);
        this.procTime.value(jobOrBatch.currProcTime());
    }

    @Override
    public void operationCompleted(WorkStation m, PrioRuleTarget justCompleted) {
        this.aveMachinesBusy.value(m.numBusy(), m.shop().simTime());
    }

    public MachineStatCollector clone() {
        try {
            return (MachineStatCollector)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new AssertionError((Object)cantHappen);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

