/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util;

import jasima.core.simulation.SimComponent;
import jasima.core.statistics.SummaryStat;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.ShopListenerBase;
import jasima.shopSim.core.WorkStation;
import java.util.Map;

public class ExtendedJobStatCollector
extends ShopListenerBase {
    private SummaryStat lateness;
    private SummaryStat noProcTime;
    private SummaryStat weightedFlowtime;
    private SummaryStat weightedTardiness;
    private SummaryStat conditionalTardiness;
    private SummaryStat weightedConditionalTardiness;
    private SummaryStat weightedTardinessWithWIP;
    private double numTardyWeighted;
    private Shop shop;

    @Override
    public void init(SimComponent sim) {
        this.noProcTime = new SummaryStat();
        this.lateness = new SummaryStat();
        this.weightedFlowtime = new SummaryStat();
        this.weightedTardiness = new SummaryStat();
        this.conditionalTardiness = new SummaryStat();
        this.weightedConditionalTardiness = new SummaryStat();
        this.numTardyWeighted = 0.0;
        this.shop = null;
    }

    @Override
    public void done(SimComponent sim) {
        this.weightedTardinessWithWIP = new SummaryStat(this.weightedTardiness);
        if (this.shop != null) {
            for (SimComponent sc : this.shop.machines().getChildren()) {
                int i;
                WorkStation m = (WorkStation)sc;
                int n = m.queue.size();
                for (i = 0; i < n; ++i) {
                    this.storeWIPJob(m.queue.get(i));
                }
                for (i = 0; i < m.numInGroup(); ++i) {
                    PrioRuleTarget j = m.getProcessedJob(i);
                    if (j == null) continue;
                    this.storeWIPJob(j);
                }
            }
        }
    }

    protected void storeWIPJob(PrioRuleTarget job) {
        for (int i = 0; i < job.numJobsInBatch(); ++i) {
            Job j = job.job(i);
            if (j.isFuture()) continue;
            double tard = Math.max(j.getShop().simTime() - j.getCurrentOperationDueDate(), 0.0);
            this.weightedTardinessWithWIP.value(j.getWeight() * tard);
        }
    }

    @Override
    public void jobReleased(Shop shop, Job j) {
        assert (this.shop == null || this.shop == shop);
        this.shop = shop;
    }

    @Override
    public void jobFinished(Shop shop, Job j) {
        if (!this.shouldCollect(j)) {
            return;
        }
        double ft = shop.simTime() - j.getRelDate();
        this.weightedFlowtime.value(j.getWeight() * ft);
        this.noProcTime.value(ft - j.procSum());
        double late = shop.simTime() - j.getDueDate();
        this.lateness.value(late);
        double tard = Math.max(late, 0.0);
        double wTard = j.getWeight() * tard;
        this.weightedTardiness.value(wTard);
        if (tard > 0.0) {
            this.conditionalTardiness.value(tard);
            this.weightedConditionalTardiness.value(wTard);
            this.numTardyWeighted += j.getWeight();
        }
    }

    @Override
    public void produceResults(SimComponent sim, Map<String, Object> res) {
        res.put("noProcTime", this.noProcTime);
        res.put("weightedFlowtimes", this.weightedFlowtime);
        res.put("lateness", this.lateness);
        res.put("weightedTardiness", this.weightedTardiness);
        res.put("weightedTardinessWithWIP", this.weightedTardinessWithWIP);
        res.put("conditionalTardiness", this.conditionalTardiness);
        res.put("weightedConditionalTardiness", this.weightedConditionalTardiness);
        res.put("weightedNumTardy", this.numTardyWeighted);
    }

    @Override
    public String toString() {
        return "ExtendedJobStatCollector";
    }
}

