/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util;

import jasima.core.simulation.SimComponent;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.Util;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.ShopListenerBase;
import java.util.Map;

public class BatchStatCollector
extends ShopListenerBase {
    private int numBatches = 1;
    private int batchSize = 2000;
    private SummaryStat[] batchFlowtimes;
    private SummaryStat[] batchTardiness;

    @Override
    public void produceResults(SimComponent c, Map<String, Object> res) {
        for (int i = 0; i < this.numBatches; ++i) {
            String prefix = "b" + i;
            Util.putMeanMaxVar(this.batchFlowtimes[i], prefix + ".flow", res);
            Util.putMeanMaxVar(this.batchTardiness[i], prefix + ".tard", res);
            res.put(prefix + ".numFinished", this.batchFlowtimes[i].numObs());
        }
    }

    @Override
    public void init(SimComponent sim) {
        this.batchFlowtimes = new SummaryStat[this.numBatches];
        this.batchTardiness = new SummaryStat[this.numBatches];
        for (int i = 0; i < this.numBatches; ++i) {
            this.batchFlowtimes[i] = new SummaryStat();
            this.batchTardiness[i] = new SummaryStat();
        }
    }

    @Override
    public void jobReleased(Shop shop, Job j) {
    }

    @Override
    public void jobFinished(Shop shop, Job j) {
        if (j.getJobNum() < this.getIgnoreFirst()) {
            return;
        }
        int batchNum = (j.getJobNum() - this.getIgnoreFirst()) / this.getBatchSize();
        if (batchNum < this.getNumBatches()) {
            double flowtime = shop.simTime() - j.getRelDate();
            double tard = Math.max(shop.simTime() - j.getDueDate(), 0.0);
            this.batchFlowtimes[batchNum].value(flowtime);
            this.batchTardiness[batchNum].value(tard);
        }
    }

    public int getNumBatches() {
        return this.numBatches;
    }

    public void setNumBatches(int numBatches) {
        this.numBatches = numBatches;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

