/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.util;

import jasima.core.simulation.SimComponent;
import jasima.core.statistics.SummaryStat;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.ShopListenerBase;
import java.util.Map;

public class BasicJobStatCollector
extends ShopListenerBase {
    private SummaryStat flowtime;
    private SummaryStat tardiness;
    private int numTardy;
    private int numFinished;
    private double cMax;

    @Override
    public void init(SimComponent c) {
        this.flowtime = new SummaryStat();
        this.tardiness = new SummaryStat();
        this.numTardy = 0;
        this.numFinished = 0;
        this.cMax = 0.0;
    }

    @Override
    public void jobFinished(Shop shop, Job j) {
        if (!this.shouldCollect(j)) {
            return;
        }
        this.cMax = shop.simTime();
        double ft = shop.simTime() - j.getRelDate();
        this.flowtime.value(ft);
        double late = shop.simTime() - j.getDueDate();
        double tard = Math.max(late, 0.0);
        this.tardiness.value(tard);
        if (tard > 0.0) {
            ++this.numTardy;
        }
        ++this.numFinished;
    }

    @Override
    public void produceResults(SimComponent c, Map<String, Object> res) {
        res.put("flowtime", this.flowtime);
        res.put("tardiness", this.tardiness);
        res.put("tardPercentage", (double)this.numTardy / (double)this.numFinished);
        res.put("numTardy", this.numTardy);
        res.put("cMax", this.cMax);
    }

    @Override
    public String toString() {
        return "BasicJobStatCollector";
    }
}

