/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.upDownStream;

import jasima.shopSim.core.Job;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.WorkStation;
import java.util.ArrayList;
import java.util.List;

public class IFTMinusUIT
extends PR {
    private static final long serialVersionUID = -8999022613610310632L;

    @Override
    public double calcPrio(PrioRuleTarget j) {
        double additionalFT = IFTMinusUIT.ift(j);
        return -(additionalFT - IFTMinusUIT.utilisedIdleTime(j));
    }

    public static double ift(PrioRuleTarget j) {
        WorkStation machine = j.getCurrMachine();
        double PT = j.currProcTime();
        double additionalFT = 0.0;
        for (int i = 0; i < machine.queue.size(); ++i) {
            double PTDifferenz;
            Job j2 = machine.queue.get(i);
            if (((PrioRuleTarget)j2).isFuture() || !((PTDifferenz = PT - ((PrioRuleTarget)j2).currProcTime()) > 0.0)) continue;
            additionalFT += PTDifferenz;
        }
        return additionalFT;
    }

    public static double utilisedIdleTime(PrioRuleTarget job) {
        double currPT = job.currProcTime();
        int nextTask = job.getTaskNumber() + 1;
        if (nextTask >= job.numOps()) {
            return 0.0;
        }
        double nextPT = job.getOps()[nextTask].getProcTime();
        double winq = IFTMinusUIT.getExtendedWINQ(job);
        double earliestArrival = IFTMinusUIT.getEarliestArrivalAfter(job);
        if (winq < currPT) {
            if (currPT + nextPT <= earliestArrival) {
                return nextPT;
            }
            return earliestArrival - currPT;
        }
        if (winq < currPT + nextPT) {
            if (currPT + nextPT <= earliestArrival) {
                return nextPT + (currPT - winq);
            }
            return earliestArrival - winq;
        }
        return 0.0;
    }

    public static double getExtendedWINQ(PrioRuleTarget job) {
        int nextTask = job.getTaskNumber() + 1;
        assert (nextTask < job.numOps());
        WorkStation mNext = job.getOps()[nextTask].getMachine();
        double winq = mNext.workContent(false);
        List<PrioRuleTarget> additionalJobs = IFTMinusUIT.findLookAheadJobs(mNext, job.currProcTime() + 1.0);
        while (additionalJobs.size() > 0) {
            int index = IFTMinusUIT.getIndexOfNextJob(additionalJobs);
            PrioRuleTarget nextJob = additionalJobs.remove(index);
            double jobArrivingIn = nextJob.getCurrMachine().againIdleIn();
            if (jobArrivingIn <= winq) {
                winq += nextJob.currProcTime();
                continue;
            }
            winq = jobArrivingIn + nextJob.currProcTime();
        }
        return winq;
    }

    private static List<PrioRuleTarget> findLookAheadJobs(WorkStation m, double threshold) {
        threshold += m.shop().simTime();
        ArrayList<PrioRuleTarget> res = new ArrayList<PrioRuleTarget>();
        PriorityQueue<Job> q = m.queue;
        int n = q.size();
        for (int i = 0; i < n; ++i) {
            Job j = q.get(i);
            if (!j.isFuture() || !(j.getArriveTime() < threshold)) continue;
            res.add(j);
        }
        return res;
    }

    public static double getEarliestArrivalAfter(PrioRuleTarget job) {
        int nextTask = job.getTaskNumber() + 1;
        assert (nextTask < job.numOps());
        WorkStation mNext = job.getOps()[nextTask].getMachine();
        List<PrioRuleTarget> additionalJobs = IFTMinusUIT.findLookAheadJobs(mNext, Double.MAX_VALUE - job.getShop().simTime());
        double earliestArrival = Double.MAX_VALUE;
        for (int i = 0; i < additionalJobs.size(); ++i) {
            PrioRuleTarget lookaheadJob = additionalJobs.get(i);
            double arrivingIn = lookaheadJob.getCurrMachine().againIdleIn();
            if (!(arrivingIn > job.currProcTime()) || !(arrivingIn < earliestArrival)) continue;
            earliestArrival = arrivingIn;
        }
        return earliestArrival;
    }

    public static int getIndexOfNextJob(List<PrioRuleTarget> additionalJobs) {
        PrioRuleTarget nextJob = additionalJobs.get(0);
        int nextJobIndex = 0;
        for (int i = 1; i < additionalJobs.size(); ++i) {
            PrioRuleTarget job = additionalJobs.get(i);
            if (!(job.getCurrMachine().againIdle() < nextJob.getCurrMachine().againIdle())) continue;
            nextJobIndex = i;
            nextJob = job;
        }
        return nextJobIndex;
    }
}

