/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.setup;

import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;

public class SNSPT
extends PR {
    private static final long serialVersionUID = 3765192665858565459L;
    protected double[][] setupMatrix;
    protected double procNorm;
    protected double setupNorm;

    public void beforeCalc(PriorityQueue<?> q) {
        if (this.setupMatrix == null) {
            this.setupMatrix = this.getOwner().getSetupMatrix();
        }
        int numJobs = 0;
        this.procNorm = 0.0;
        this.setupNorm = 0.0;
        for (int i = 0; i < q.size(); ++i) {
            Object j = q.get(i);
            if (this.arrivesTooLate((PrioRuleTarget)j)) continue;
            this.procNorm += ((PrioRuleTarget)j).currProcTime();
            this.setupNorm += this.setupMatrix[this.getOwner().currMachine.setupState][((PrioRuleTarget)j).getCurrentOperation().getSetupState()];
            ++numJobs;
        }
        this.procNorm /= (double)numJobs;
        this.setupNorm /= (double)numJobs;
        super.beforeCalc(q);
    }

    @Override
    public double calcPrio(PrioRuleTarget job) {
        if (this.arrivesTooLate(job)) {
            return -1.7976931348623157E308;
        }
        double sRatio = this.setupNorm != 0.0 ? this.setupMatrix[this.getOwner().currMachine.setupState][job.getCurrentOperation().getSetupState()] / this.setupNorm : 0.0;
        return -(sRatio + job.currProcTime() / this.procNorm);
    }
}

