/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.setup;

import jasima.shopSim.core.Job;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.prioRules.setup.MMS;
import java.util.HashMap;
import java.util.Map;

public class MASP
extends MMS {
    private static final long serialVersionUID = -464213521355057733L;
    protected Map<String, Double> sumProcTimePerFamily = new HashMap<String, Double>();

    @Override
    public void beforeCalc(PriorityQueue<?> q) {
        this.sumProcTimePerFamily.clear();
        assert (this.sumProcTimePerFamily.isEmpty());
        for (int i = 0; i < q.size(); ++i) {
            Object j = q.get(i);
            if (this.arrivesTooLate((PrioRuleTarget)j)) continue;
            String sf = "" + ((PrioRuleTarget)j).getCurrentOperation().getSetupState();
            if (this.sumProcTimePerFamily.get(sf) == null) {
                this.sumProcTimePerFamily.put(sf, ((PrioRuleTarget)j).currProcTime());
                continue;
            }
            double familyValue = this.sumProcTimePerFamily.get(sf) + ((PrioRuleTarget)j).currProcTime();
            this.sumProcTimePerFamily.put(sf, familyValue);
        }
        super.beforeCalc(q);
    }

    @Override
    public double calcPrio(PrioRuleTarget j) {
        if (this.arrivesTooLate(j)) {
            return -1.7976931348623157E308;
        }
        double setup = this.getOwner().getSetupMatrix()[this.getOwner().currMachine.setupState][j.getCurrentOperation().getSetupState()];
        String family = "" + j.getCurrentOperation().getSetupState();
        return -(setup + this.sumProcTimePerFamily.get(family)) / (double)((Integer)this.jobsPerFamily.get(family)).intValue();
    }

    public double sumFamilyProcessingTime(PrioRuleTarget j) {
        int family = j.getCurrentOperation().getSetupState();
        PriorityQueue<Job> q = j.getCurrMachine().queue;
        assert (q.size() > 0);
        double procTime = 0.0;
        for (int i = 0; i < q.size(); ++i) {
            Job job = q.get(i);
            if (this.arrivesTooLate(job) || ((PrioRuleTarget)job).getCurrentOperation().getSetupState() != family) continue;
            procTime += ((PrioRuleTarget)job).currProcTime();
        }
        return procTime;
    }
}

