/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.setup;

import jasima.shopSim.core.Job;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;

public class FCR
extends PR {
    private static final long serialVersionUID = -8926344875809333367L;

    @Override
    public double calcPrio(PrioRuleTarget j) {
        if (this.arrivesTooLate(j)) {
            return -1.7976931348623157E308;
        }
        return -this.earliestFamilyCR(j);
    }

    public double earliestFamilyCR(PrioRuleTarget j) {
        int family = j.getCurrentOperation().getSetupState();
        PriorityQueue<Job> q = j.getCurrMachine().queue;
        assert (q.size() > 0);
        double cr = Double.POSITIVE_INFINITY;
        for (int i = 0; i < q.size(); ++i) {
            Job job = q.get(i);
            if (this.arrivesTooLate(job) || job.getCurrentOperation().getSetupState() != family) continue;
            double procRem = job.remainingProcTime();
            double jobcr = (job.getDueDate() - job.getShop().simTime()) / procRem;
            if (!(jobcr < cr)) continue;
            cr = jobcr;
        }
        assert (cr != Double.POSITIVE_INFINITY);
        return cr;
    }
}

