/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.setup;

import jasima.shopSim.core.Job;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;

public class ECR
extends PR {
    private static final long serialVersionUID = -122785104940341037L;
    public final double L;
    public final double U;
    public final double B;
    public final double D;
    private double[][] setupMatrix;

    public ECR(double L, double U, double B, double D) {
        this.L = L;
        this.U = U;
        this.B = B;
        this.D = D;
    }

    public void beforeCalc(PriorityQueue<?> q) {
        if (this.setupMatrix == null) {
            this.setupMatrix = this.getOwner().getSetupMatrix();
        }
        super.beforeCalc(q);
    }

    @Override
    public double calcPrio(PrioRuleTarget j) {
        if (this.arrivesTooLate(j)) {
            return -1.7976931348623157E308;
        }
        double CR2 = (j.getDueDate() - j.getShop().simTime()) / j.remainingProcTime();
        if (CR2 < this.L || CR2 > this.U) {
            return -1.7976931348623157E308;
        }
        PriorityQueue<Job> q = j.getCurrMachine().queue;
        assert (q.size() > 0);
        double totalUrgency = 0.0;
        int n = q.size();
        for (int i = 0; i < n; ++i) {
            double a;
            double r;
            Job job = q.get(i);
            if (this.arrivesTooLate(job)) continue;
            if (job.equals(j)) {
                r = j.remainingProcTime() - j.currProcTime();
                a = j.getDueDate() - j.getShop().simTime() - this.setupMatrix[this.getOwner().currMachine.setupState][j.getCurrentOperation().getSetupState()] - j.currProcTime();
            } else {
                r = job.remainingProcTime();
                a = job.getDueDate() - j.getShop().simTime() - this.setupMatrix[this.getOwner().currMachine.setupState][j.getCurrentOperation().getSetupState()] - j.currProcTime() - this.setupMatrix[j.getCurrentOperation().getSetupState()][job.getCurrentOperation().getSetupState()];
            }
            totalUrgency += this.calculateUrgency(r, a);
        }
        return -totalUrgency;
    }

    public double calculateUrgency(double r, double a) {
        if (r <= 0.0) {
            return 0.0;
        }
        if (a >= r) {
            return Math.pow(r / a, 2.0);
        }
        return this.B + this.D * (r - a);
    }
}

