/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.setup;

import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;

public class ATCS
extends PR {
    private static final long serialVersionUID = -331130943946735200L;
    private double k1;
    private double k2;
    protected double[][] setupMatrix;
    protected double slackNorm;
    protected double setupNorm;

    public ATCS() {
        this(1.0, 1.0);
    }

    public ATCS(double k1, double k2) {
        this.k1 = k1;
        this.k2 = k2;
    }

    public void beforeCalc(PriorityQueue<?> q) {
        if (this.setupMatrix == null) {
            this.setupMatrix = this.getOwner().getSetupMatrix();
        }
        int numJobs = 0;
        this.slackNorm = 0.0;
        this.setupNorm = 0.0;
        for (int i = 0; i < q.size(); ++i) {
            Object j = q.get(i);
            if (this.arrivesTooLate((PrioRuleTarget)j)) continue;
            this.slackNorm += ((PrioRuleTarget)j).currProcTime();
            this.setupNorm += this.setupMatrix[this.getOwner().currMachine.setupState][((PrioRuleTarget)j).getCurrentOperation().getSetupState()];
            ++numJobs;
        }
        this.slackNorm = this.slackNorm / (double)numJobs * this.k1;
        this.setupNorm = this.setupNorm / (double)numJobs * this.k2;
        super.beforeCalc(q);
    }

    @Override
    public double calcPrio(PrioRuleTarget job) {
        if (this.arrivesTooLate(job)) {
            return -1.7976931348623157E308;
        }
        double slack = job.getCurrentOperationDueDate() - job.getShop().simTime() - job.currProcTime();
        double prod1 = -Math.max(slack, 0.0) / this.slackNorm;
        double prod2 = this.setupNorm != 0.0 ? -this.setupMatrix[this.getOwner().currMachine.setupState][job.getCurrentOperation().getSetupState()] / this.setupNorm : 0.0;
        return Math.log(job.getWeight() / job.currProcTime()) + prod1 + prod2;
    }

    @Override
    public String getName() {
        return "ATCS(k1=" + this.k1 + ";k2=" + this.k2 + ")";
    }

    public double getK1() {
        return this.k1;
    }

    public void setK1(double k1) {
        this.k1 = k1;
    }

    public double getK2() {
        return this.k2;
    }

    public void setK2(double k2) {
        this.k2 = k2;
    }
}

