/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.meta;

import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.prioRules.meta.LookaheadThreshold;

public class FixedLAThreshold
extends LookaheadThreshold {
    private static final long serialVersionUID = 4971777067231682191L;
    private double maxWait;

    public FixedLAThreshold(PR baseRule, double maxWait) {
        this.setMaxWait(maxWait);
        this.setTieBreaker(baseRule);
    }

    public FixedLAThreshold(PR baseRule) {
        this(baseRule, 0.0);
    }

    @Override
    public boolean arrivesTooLate(PrioRuleTarget prt) {
        return this.arrivesTooLate(prt, this.getMaxWait());
    }

    @Override
    public void setTieBreaker(PR tieBreaker) {
        if (this.getTieBreaker() != null) {
            this.getTieBreaker().setTieBreaker(tieBreaker);
        } else {
            super.setTieBreaker(tieBreaker);
        }
    }

    @Override
    public String getName() {
        return "FLA(" + this.getMaxWait() + ")";
    }

    public double getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(double maxWait) {
        if (maxWait < 0.0) {
            throw new IllegalArgumentException("maxWait " + maxWait + " can not be negative!");
        }
        this.maxWait = maxWait;
    }
}

