/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.meta;

import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.prioRules.meta.LookaheadThreshold;

public class AdaptiveLAThreshold
extends LookaheadThreshold {
    private static final long serialVersionUID = -9044425584894392686L;
    private double maxWaitRelative;
    private double maxWait;

    public AdaptiveLAThreshold(PR baseRule) {
        this(baseRule, 1.0);
    }

    public AdaptiveLAThreshold(double maxWaitRelative) {
        this(null, maxWaitRelative);
    }

    public AdaptiveLAThreshold(PR baseRule, double maxWaitRelative) {
        this.setMaxWaitRelative(maxWaitRelative);
        this.setTieBreaker(baseRule);
    }

    public void beforeCalc(PriorityQueue<?> q) {
        this.maxWait = this.getMaxWaitRelative() * this.maxProcTimeWaiting(q);
    }

    @Override
    public boolean arrivesTooLate(PrioRuleTarget prt) {
        return this.arrivesTooLate(prt, this.maxWait);
    }

    public double maxProcTimeWaiting(PriorityQueue<?> q) {
        double[][] setupMatrix = this.getOwner().getSetupMatrix();
        int currSetupState = this.getOwner().currMachine.setupState;
        double res = 0.0;
        int n = q.size();
        for (int i = 0; i < n; ++i) {
            Operation o;
            double timeToComplete;
            Object j = q.get(i);
            if (((PrioRuleTarget)j).isFuture() || !((timeToComplete = setupMatrix[currSetupState][(o = ((PrioRuleTarget)j).getCurrentOperation()).getSetupState()] + o.getProcTime() + setupMatrix[o.getSetupState()][currSetupState]) > res)) continue;
            res = timeToComplete;
        }
        return res;
    }

    @Override
    public String getName() {
        return "ALA(" + this.getMaxWaitRelative() + ")";
    }

    public double getMaxWaitRelative() {
        return this.maxWaitRelative;
    }

    public void setMaxWaitRelative(double maxWaitRelative) {
        if (maxWaitRelative < 0.0 || maxWaitRelative > 1.0) {
            throw new IllegalArgumentException("maxWaitRelative " + maxWaitRelative + " has to be within [0,1]!");
        }
        this.maxWaitRelative = maxWaitRelative;
    }
}

