/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.gp;

import jasima.shopSim.core.Job;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.prioRules.basic.SLK;
import jasima.shopSim.prioRules.gp.GPRuleBase;
import java.util.HashMap;
import java.util.Map;

public class WSC2010_GPRuleSize199
extends GPRuleBase {
    private static final long serialVersionUID = -8457782199185178603L;
    private Map<String, Integer> famSizes;
    private double sAvg;

    public void beforeCalc(PriorityQueue<?> q) {
        super.beforeCalc(q);
        this.calcNumCompatible();
        this.sAvg = this.calcSetupAvg();
    }

    private int numCompatible(PrioRuleTarget j) {
        String bf = j.getCurrentOperation().getBatchFamily();
        return this.famSizes.get(bf);
    }

    private double setupAvg() {
        return this.sAvg;
    }

    private void calcNumCompatible() {
        this.famSizes = new HashMap<String, Integer>();
        PriorityQueue<Job> q = this.getOwner().queue;
        int n = q.size();
        for (int i = 0; i < n; ++i) {
            Job j = q.get(i);
            String family = j.getCurrentOperation().getBatchFamily();
            Integer k = this.famSizes.get(family);
            if (k == null || "BATCH_INCOMPATIBLE".equals(family)) {
                k = 0;
            }
            this.famSizes.put(family, k + 1);
        }
    }

    private double calcSetupAvg() {
        PriorityQueue<Job> q = this.getOwner().queue;
        assert (q.size() > 0);
        double[][] setupMatrix = this.getOwner().getSetupMatrix();
        int machineSetup = this.getOwner().currMachine.setupState;
        int numNonFutures = 0;
        double setupAvg = 0.0;
        int n = q.size();
        for (int i = 0; i < n; ++i) {
            Job j2 = q.get(i);
            assert (!j2.isFuture());
            if (j2.isFuture()) continue;
            setupAvg += setupMatrix[machineSetup][j2.getCurrentOperation().getSetupState()];
            ++numNonFutures;
        }
        return setupAvg / (double)numNonFutures;
    }

    private double setupTime(PrioRuleTarget j) {
        assert (j.getCurrMachine() == this.getOwner());
        double[][] setupMatrix = j.getCurrMachine().getSetupMatrix();
        int machineSetup = j.getCurrMachine().currMachine.setupState;
        return setupMatrix[machineSetup][j.getCurrentOperation().getSetupState()];
    }

    @Override
    public double calcPrio(PrioRuleTarget j) {
        double bf = this.numCompatible(j);
        double ttd = j.getDueDate() - j.getShop().simTime();
        double w = j.getWeight();
        double sl = SLK.slack(j);
        double s = this.setupTime(j);
        double rpt = j.remainingProcTime();
        double sAvg = this.setupAvg();
        return bf * WSC2010_GPRuleSize199.max(bf * WSC2010_GPRuleSize199.ifte(WSC2010_GPRuleSize199.max(1.0, rpt) - sl, w, bf) * (rpt * WSC2010_GPRuleSize199.ifte(bf - sl, w, bf) / sl + 2.0 * rpt / sl - s) + rpt * WSC2010_GPRuleSize199.ifte(bf - s, w, bf) / sl + rpt / sl - s, WSC2010_GPRuleSize199.ifte(bf - sl, w, bf) * WSC2010_GPRuleSize199.max(-WSC2010_GPRuleSize199.ifte(WSC2010_GPRuleSize199.max(1.0, rpt) - WSC2010_GPRuleSize199.max(sl, ttd), w, bf) - rpt / sl + (bf - WSC2010_GPRuleSize199.max(1.0, ttd)) * WSC2010_GPRuleSize199.ifte(bf - WSC2010_GPRuleSize199.max(1.0, ttd), w, bf) + bf, sAvg + bf * WSC2010_GPRuleSize199.ifte(WSC2010_GPRuleSize199.max(1.0, rpt) - WSC2010_GPRuleSize199.max(sl, ttd), w, bf) - s - WSC2010_GPRuleSize199.max(1.0, WSC2010_GPRuleSize199.max(rpt, sl)) + WSC2010_GPRuleSize199.max(1.0, rpt) + 1.0) + rpt / sl - s) * WSC2010_GPRuleSize199.ifte(WSC2010_GPRuleSize199.max(bf * rpt * WSC2010_GPRuleSize199.ifte(WSC2010_GPRuleSize199.max(1.0, rpt) - sl, w, bf) / sl - WSC2010_GPRuleSize199.ifte(bf - sl, w, bf) + (bf - WSC2010_GPRuleSize199.max(1.0, ttd)) * WSC2010_GPRuleSize199.ifte(bf - WSC2010_GPRuleSize199.max(1.0, ttd), w, bf), sAvg + bf * WSC2010_GPRuleSize199.ifte(WSC2010_GPRuleSize199.max(1.0, rpt) - WSC2010_GPRuleSize199.max(sl, ttd), w, bf) - s - WSC2010_GPRuleSize199.max(1.0, WSC2010_GPRuleSize199.max(rpt, sl)) + WSC2010_GPRuleSize199.max(1.0, rpt) + 1.0) * w, w, bf);
    }
}

