/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.batch;

import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.prioRules.setup.ATCS;

public class BATCS
extends ATCS {
    private static final long serialVersionUID = -1515862598920923584L;

    public BATCS(double k1, double k2) {
        super(k1, k2);
    }

    @Override
    public double calcPrio(PrioRuleTarget prt) {
        if (this.arrivesTooLate(prt)) {
            return -1.7976931348623157E308;
        }
        double slack = this.getEarliestODD(prt) - prt.getShop().simTime() - prt.currProcTime();
        double prod1 = -Math.max(slack, 0.0) / this.slackNorm;
        double prod2 = this.setupNorm != 0.0 ? -this.setupMatrix[this.getOwner().currMachine.setupState][prt.getCurrentOperation().getSetupState()] / this.setupNorm : 0.0;
        return Math.log(prt.getWeight() / prt.currProcTime()) + prod1 + prod2 + Math.log((double)prt.numJobsInBatch() / (double)prt.getCurrentOperation().getMaxBatchSize());
    }

    public double getEarliestODD(PrioRuleTarget j) {
        double odd = j.job(0).getCurrentOperationDueDate();
        for (int i = 1; i < j.numJobsInBatch(); ++i) {
            double d = j.job(i).getCurrentOperationDueDate();
            if (!(d < odd)) continue;
            odd = d;
        }
        return odd;
    }

    @Override
    public String getName() {
        return "BATCS(k1=" + this.getK1() + ";k2=" + this.getK2() + ")";
    }

    public static class Variant1
    extends ATCS {
        private static final long serialVersionUID = 4173814503454519153L;

        public Variant1(double k1, double k2) {
            super(k1, k2);
        }

        @Override
        public double calcPrio(PrioRuleTarget prt) {
            if (this.arrivesTooLate(prt)) {
                return -1.7976931348623157E308;
            }
            double prod1 = -this.getTotalOSlack(prt) / this.slackNorm;
            double prod2 = this.setupNorm != 0.0 ? -this.setupMatrix[this.getOwner().currMachine.setupState][prt.getCurrentOperation().getSetupState()] / this.setupNorm : 0.0;
            return Math.log(prt.getWeight() / prt.currProcTime()) + prod1 + prod2 + Math.log((double)prt.numJobsInBatch() / (double)prt.getCurrentOperation().getMaxBatchSize());
        }

        public double getTotalOSlack(PrioRuleTarget b) {
            double oSlack = 0.0;
            for (int i = 0; i < b.numJobsInBatch(); ++i) {
                oSlack += Math.max(b.job(i).getCurrentOperationDueDate() - b.getShop().simTime() - b.currProcTime(), 0.0);
            }
            return oSlack;
        }

        @Override
        public String getName() {
            return "BATCS_V1(k1=" + this.getK1() + ";k2=" + this.getK2() + ")";
        }
    }
}

