/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.basic;

import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;

public class CR
extends PR {
    private static final long serialVersionUID = 1690734931010618195L;

    @Override
    public double calcPrio(PrioRuleTarget job) {
        return -((job.getDueDate() - job.getShop().simTime()) / job.remainingProcTime());
    }

    public static class Variant2
    extends PR {
        private static final long serialVersionUID = 6097877363880443570L;

        @Override
        public double calcPrio(PrioRuleTarget job) {
            return -(job.getDueDate() - job.getShop().simTime()) / (1.0 + job.remainingProcTime());
        }

        @Override
        public String getName() {
            return "CR_V2";
        }
    }

    public static class Variant1
    extends PR {
        private static final long serialVersionUID = -7545346726088550611L;

        @Override
        public double calcPrio(PrioRuleTarget job) {
            double slack = job.getDueDate() - job.getShop().simTime();
            if (slack > 0.0) {
                return -(1.0 + slack) / (1.0 + job.remainingProcTime());
            }
            return -(1.0 / ((1.0 - slack) * (1.0 + job.remainingProcTime())));
        }

        @Override
        public String getName() {
            return "CR_V1";
        }
    }
}

