/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.prioRules.basic;

import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;

public class ATC
extends PR {
    private static final long serialVersionUID = -5302187389726254037L;
    private double k;
    protected double slackNorm;

    public ATC() {
        this(1.0);
    }

    public ATC(double k) {
        this.setK(k);
    }

    public void beforeCalc(PriorityQueue<?> q) {
        int numJobs = 0;
        this.slackNorm = 0.0;
        for (int i = 0; i < q.size(); ++i) {
            Object j = q.get(i);
            if (this.arrivesTooLate((PrioRuleTarget)j)) continue;
            this.slackNorm += ((PrioRuleTarget)j).currProcTime();
            ++numJobs;
        }
        this.slackNorm = this.slackNorm / (double)numJobs * this.k;
        super.beforeCalc(q);
    }

    @Override
    public double calcPrio(PrioRuleTarget job) {
        if (this.arrivesTooLate(job)) {
            return -1.7976931348623157E308;
        }
        double slack = job.getCurrentOperationDueDate() - job.getShop().simTime() - job.currProcTime();
        double prod1 = -Math.max(slack, 0.0) / this.slackNorm;
        return job.getWeight() / job.currProcTime() * Math.exp(prod1);
    }

    @Override
    public String getName() {
        return "ATC(k=" + this.getK() + ")";
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }
}

