/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.models.staticShop;

import jasima.shopSim.core.Operation;
import jasima.shopSim.core.Route;
import jasima.shopSim.core.ShopExperiment;
import jasima.shopSim.core.StaticJobSource;
import jasima.shopSim.util.TextFileReader;
import jasima.shopSim.util.modelDef.ShopDef;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class StaticShopExperiment
extends ShopExperiment {
    private static final long serialVersionUID = 3907065922245526545L;
    private String instFileName;
    private URI instURI;
    private ShopDef shopDef;
    private double dueDateTightness = Double.NaN;
    private RoundingMode roundingMode = RoundingMode.NONE;

    @Override
    public StaticShopExperiment clone() {
        StaticShopExperiment c = (StaticShopExperiment)super.clone();
        if (this.shopDef != null) {
            c.shopDef = this.shopDef.clone();
        }
        return c;
    }

    @Override
    protected void createShop() {
        super.createShop();
        if (this.getInstFileName() == null && this.getInstURI() == null && this.getShopDef() == null) {
            throw new IllegalArgumentException("Either 'instFileName', 'instURI' or 'shopDef' have to be specified.");
        }
        ShopDef def = this.getShopDef();
        if (def == null) {
            def = this.loadWithTextFileReader();
        }
        def.getShopConfigurator().configureSimulation(this.sim);
        def.getShopConfigurator().configureMdl(this.shop);
    }

    @Override
    protected void configureShop() {
        super.configureShop();
        if (!Double.isNaN(this.getDueDateTightness())) {
            StaticJobSource src = (StaticJobSource)this.shop.sources().getChild(0);
            StaticJobSource.JobSpec[] jobs = src.jobs;
            int n = src.jobs.length;
            for (int i = 0; i < n; ++i) {
                StaticJobSource.JobSpec orig = jobs[i];
                Route route = this.shop.routes[orig.routeNum];
                double procSum = 0.0;
                for (Operation o : route.ops()) {
                    procSum += o.getProcTime();
                }
                double dd = this.getDueDateTightness() * procSum;
                if (this.getRoundingMode() == RoundingMode.FLOOR) {
                    dd = Math.floor(dd);
                } else if (this.getRoundingMode() == RoundingMode.CEIL) {
                    dd = Math.ceil(dd);
                } else if (this.getRoundingMode() == RoundingMode.ROUND) {
                    dd = Math.round(dd);
                }
                jobs[i] = new StaticJobSource.JobSpec(orig.routeNum, orig.releaseDate, dd, orig.weight, orig.name);
            }
        }
    }

    protected ShopDef loadWithTextFileReader() {
        URI uri = null;
        if (this.getInstFileName() != null) {
            File f = new File(this.getInstFileName());
            if (f.exists()) {
                uri = f.toURI();
            } else {
                URL u = this.getClass().getResource(this.getInstFileName());
                if (u == null) {
                    u = Thread.currentThread().getContextClassLoader().getResource(this.getInstFileName());
                }
                if (u != null) {
                    try {
                        uri = u.toURI();
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (uri == null) {
            uri = this.getInstURI();
        }
        if (uri == null) {
            Object src = this.getInstURI();
            if (src == null) {
                src = this.getInstFileName();
            }
            throw new IllegalArgumentException("Could not load model from '" + src.toString() + "'. Perhaps file is not accessible.");
        }
        try {
            InputStream inp = uri.toURL().openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inp));
            TextFileReader r = new TextFileReader();
            r.readData(in);
            in.close();
            return r.getShopDef();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getInstFileName() {
        return this.instFileName;
    }

    public void setInstFileName(String instFileName) {
        this.instFileName = instFileName;
    }

    public URI getInstURI() {
        return this.instURI;
    }

    public void setInstURI(URI instURI) {
        this.instURI = instURI;
    }

    public double getDueDateTightness() {
        return this.dueDateTightness;
    }

    public void setDueDateTightness(double dueDateTightness) {
        this.dueDateTightness = dueDateTightness;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public ShopDef getShopDef() {
        return this.shopDef;
    }

    public void setShopDef(ShopDef shopDef) {
        this.shopDef = shopDef;
    }

    public static enum RoundingMode {
        NONE,
        FLOOR,
        CEIL,
        ROUND;

    }
}

