/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.models.mimac;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.arrivalprocess.ArrivalsStationary;
import jasima.shopSim.core.DynamicJobSource;
import jasima.shopSim.core.ShopExperiment;
import jasima.shopSim.util.TextFileReader;
import jasima.shopSim.util.modelDef.ShopDef;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class MimacExperiment
extends ShopExperiment {
    private static final long serialVersionUID = -1460963355772995049L;
    private DataSet scenario;
    private DblSequence jobWeights;
    private DblSequence dueDateFactors;
    private DblSequence[] interArrivalTimes;
    private boolean arrivalAtTimeZero = false;

    @Override
    protected void createShop() {
        super.createShop();
        this.getScenario().getShopDef().getShopConfigurator().configureMdl(this.shop);
        DblSequence[] iats = this.getInterArrivalTimes();
        if (iats != null && this.shop.routes.length != iats.length) {
            throw new RuntimeException("Number of routes (" + this.shop.routes.length + ") and inter-arrival streams (" + iats.length + ") doesn't match.");
        }
        for (int i = 0; i < this.shop.routes.length; ++i) {
            DynamicJobSource s = new DynamicJobSource();
            s.setRoute(this.shop.routes[i]);
            ArrivalsStationary arrivals = new ArrivalsStationary();
            arrivals.setArrivalAtTimeZero(this.isArrivalAtTimeZero());
            if (iats != null && iats[i] != null) {
                arrivals.setInterArrivalTimes(iats[i]);
            } else {
                arrivals.setInterArrivalTimes(new DblDistribution((RealDistribution)new ExponentialDistribution(this.getScenario().defaultIats[i])));
            }
            s.setArrivalProcess(arrivals);
            if (this.getDueDateFactors() != null) {
                s.setDueDateFactors(this.getDueDateFactors());
            }
            if (this.getJobWeights() != null) {
                s.setJobWeights(this.getJobWeights());
            }
            this.shop.addJobSource(s);
        }
    }

    @Override
    protected void configureShop() {
        super.configureShop();
    }

    @Override
    public MimacExperiment clone() {
        MimacExperiment c = (MimacExperiment)super.clone();
        if (this.jobWeights != null) {
            c.jobWeights = this.jobWeights.clone();
        }
        if (this.dueDateFactors != null) {
            c.dueDateFactors = this.dueDateFactors.clone();
        }
        if (this.interArrivalTimes != null) {
            c.interArrivalTimes = new DblSequence[this.interArrivalTimes.length];
            for (int i = 0; i < this.interArrivalTimes.length; ++i) {
                c.interArrivalTimes[i] = this.interArrivalTimes[i].clone();
            }
        }
        return c;
    }

    public void setScenario(DataSet scenario) {
        this.scenario = scenario;
    }

    public DataSet getScenario() {
        return this.scenario;
    }

    public void setInterArrivalTimes(DblSequence[] interArrivalTimes) {
        this.interArrivalTimes = interArrivalTimes;
    }

    public DblSequence[] getInterArrivalTimes() {
        return this.interArrivalTimes;
    }

    public void setJobWeights(DblSequence jobWeights) {
        this.jobWeights = jobWeights;
    }

    public DblSequence getJobWeights() {
        return this.jobWeights;
    }

    public void setDueDateFactors(DblSequence dueDateFactors) {
        this.dueDateFactors = dueDateFactors;
    }

    public DblSequence getDueDateFactors() {
        return this.dueDateFactors;
    }

    public void setArrivalAtTimeZero(boolean arrivalAtTimeZero) {
        this.arrivalAtTimeZero = arrivalAtTimeZero;
    }

    public boolean isArrivalAtTimeZero() {
        return this.arrivalAtTimeZero;
    }

    public static enum DataSet {
        FAB4("fab4.txt", new double[]{352.94200000192154, 3214.289997614126}),
        FAB4r("fab4r.txt", new double[]{352.94200000192154, 3214.289997614126}),
        FAB6("fab6.txt", new double[]{1828.5714285714287, 5578.692493946732, 2635.3515166365623, 2185.405325987579, 655.6257469694382, 1033.8947532619864, 2466.105309170228, 2859.506886377673, 2116.6095155149906});

        public final String resourceName;
        public final double[] defaultIats;
        private ShopDef def = null;

        private DataSet(String resoureName, double[] defaultIats) {
            this.resourceName = resoureName;
            this.defaultIats = defaultIats;
        }

        public synchronized ShopDef getShopDef() {
            ShopDef def = this.def;
            if (def == null) {
                TextFileReader reader = this.createNewReader();
                def = reader.getShopDef();
            }
            return def;
        }

        private TextFileReader createNewReader() {
            InputStream inp;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String name = this.resourceName;
            String baseName = MimacExperiment.class.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
            if ((inp = cl.getResourceAsStream(name)) == null) {
                throw new RuntimeException("Can't find input stream '" + name + "'.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(inp));
            TextFileReader reader = new TextFileReader();
            reader.readData(in);
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return reader;
        }
    }
}

