/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.models.mimac;

import jasima.core.simulation.SimComponent;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.Util;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.ShopListenerBase;
import java.util.HashMap;
import java.util.Map;

public class FlowtimePerProductCollector
extends ShopListenerBase {
    private HashMap<Integer, SummaryStat> flowtimesPerProduct;

    @Override
    public void init(SimComponent c) {
        this.flowtimesPerProduct = new HashMap();
    }

    @Override
    public void jobFinished(Shop shop, Job j) {
        if (!this.shouldCollect(j)) {
            return;
        }
        double flowtime = shop.simTime() - j.getRelDate();
        SummaryStat stats = this.flowtimesPerProduct.get(j.getJobType());
        if (stats == null) {
            stats = new SummaryStat();
            this.flowtimesPerProduct.put(j.getJobType(), stats);
        }
        stats.value(flowtime);
    }

    @Override
    public void produceResults(SimComponent c, Map<String, Object> res) {
        for (Integer prodTypeId : this.flowtimesPerProduct.keySet()) {
            String prefix = "p" + prodTypeId;
            SummaryStat stats = this.flowtimesPerProduct.get(prodTypeId);
            Util.putMeanMaxVar(stats, prefix + ".flow", res);
            res.put(prefix + ".numFinished", stats.numObs());
        }
    }
}

