/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.models.dynamicShop;

import jasima.core.random.continuous.DblConst;
import jasima.core.random.continuous.DblDistribution;
import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntUniformRange;
import jasima.core.simulation.arrivalprocess.ArrivalsStationary;
import jasima.core.util.Pair;
import jasima.core.util.TypeUtil;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import jasima.shopSim.core.DynamicJobSource;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.JobSource;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.ShopExperiment;
import jasima.shopSim.core.ShopListenerBase;
import jasima.shopSim.core.WorkStation;
import jasima.shopSim.util.BasicJobStatCollector;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class DynamicShopExperiment
extends ShopExperiment {
    private static final long serialVersionUID = -7289579158397939550L;
    private static final double MINUTES_PER_DAY = 1440.0;
    private double utilLevel = 0.85;
    private DblSequence dueDateFactor = new DblConst(4.0);
    private int numMachines = 10;
    private Scenario scenario = Scenario.JOB_SHOP;
    private DblSequence weights = null;
    private Pair<Integer, Integer> numOps = new Pair<Integer, Integer>(-1, -1);
    private DblSequence procTimes = new IntUniformRange(1, 49);
    private int stopArrivalsAfterNumJobs = 2500;
    protected JobSource src;

    public DynamicShopExperiment() {
        this.addShopListener(new BasicJobStatCollector());
    }

    @Override
    public void init() {
        super.init();
        if (this.getScenario() == null) {
            throw new IllegalArgumentException(I18n.defFormat("No scenario specified, should be one of %s.", Arrays.toString((Object[])Scenario.values())));
        }
        Objects.requireNonNull(this.procTimes);
        ShopListenerBase stopSrc = new ShopListenerBase(){
            int maxJob;
            int numJobs;
            {
                this.numJobs = this.maxJob = DynamicShopExperiment.this.getStopArrivalsAfterNumJobs();
            }

            @Override
            public void jobFinished(Shop shop, Job j) {
                if (j.getJobNum() < this.maxJob && --this.numJobs == 0) {
                    DynamicShopExperiment.this.src.stopArrivals = true;
                }
            }
        };
        this.shop.addListener(stopSrc);
    }

    @Override
    protected void createShop() {
        super.createShop();
        this.createMachines();
        this.src = this.createJobSource();
        this.shop.addJobSource(this.src);
    }

    @Override
    protected void configureShop() {
        super.configureShop();
        if (this.getStopAfterNumJobs() <= 0) {
            this.shop.setStopAfterNumJobs(10 * this.getStopArrivalsAfterNumJobs());
        }
    }

    private void createMachines() {
        for (int n = 0; n < this.getNumMachines(); ++n) {
            WorkStation m = new WorkStation(1);
            this.shop.addMachine(m);
        }
    }

    protected JobSource createJobSource() {
        int max;
        DynamicJobSource src = new DynamicJobSource(){

            @Override
            protected Operation[] createRoute() {
                int n = this.getNumOps().nextInt();
                assert (n > 0);
                Operation[] ops = Util.initializedArray(n, Operation.class);
                boolean[] machineChosen = new boolean[DynamicShopExperiment.this.getNumMachines()];
                for (int i = 0; i < n; ++i) {
                    int mi = -1;
                    while (machineChosen[mi = this.getMachIdx().nextInt()]) {
                    }
                    WorkStation m = (WorkStation)DynamicShopExperiment.this.shop.machines().getChild(mi);
                    machineChosen[mi] = true;
                    if (DynamicShopExperiment.this.getScenario() != Scenario.JOB_SHOP) continue;
                    ops[i].setMachine(m);
                }
                if (DynamicShopExperiment.this.getScenario() == Scenario.FLOW_SHOP) {
                    int k = 0;
                    int j = DynamicShopExperiment.this.shop.machines().numChildren();
                    for (int i = 0; i < j; ++i) {
                        if (!machineChosen[i]) continue;
                        ops[k++].setMachine((WorkStation)DynamicShopExperiment.this.shop.machines().getChild(i));
                    }
                }
                for (Operation o : ops) {
                    o.setProcTime(this.getProcTimes().nextDbl());
                }
                return ops;
            }
        };
        double iaMean = this.calcIaMean();
        ArrivalsStationary arrivals = new ArrivalsStationary();
        arrivals.setInterArrivalTimes(new DblDistribution((RealDistribution)new ExponentialDistribution(iaMean)));
        arrivals.setName("arrivalStream");
        src.setArrivalProcess(arrivals);
        int min = this.getNumOpsMin() > 0 ? this.getNumOpsMin() : this.getNumMachines();
        int n = max = this.getNumOpsMax() > 0 ? this.getNumOpsMax() : this.getNumMachines();
        if (min > max) {
            throw new IllegalArgumentException(I18n.defFormat("invalid range for numOps: [%d; %d]", this.getNumOpsMin(), this.getNumOpsMax()));
        }
        if (max > this.getNumMachines()) {
            throw new IllegalArgumentException(I18n.defFormat("Can't have more operations (%d) than there are machines (%d).", max, this.getNumMachines()));
        }
        IntUniformRange numOps = new IntUniformRange("numOpsStream", min, max);
        src.setNumOps(numOps);
        DblSequence procTimes2 = TypeUtil.cloneIfPossible(this.getProcTimes());
        procTimes2.setName("procTimesStream");
        src.setProcTimes(procTimes2);
        src.setMachIdx(new IntUniformRange("machIdxStream", 0, this.getNumMachines() - 1));
        src.setDueDateFactors(TypeUtil.cloneIfPossible(this.getDueDateFactor()));
        if (this.getWeights() != null) {
            src.setJobWeights(this.getWeights().clone());
        }
        return src;
    }

    @Override
    protected void done() {
        this.aborted = this.shop.jobsStarted - this.shop.jobsFinished > 0 ? 1 : 0;
        super.done();
    }

    private double calcIaMean() {
        int opsMin = this.getNumOpsMin() > 0 ? this.getNumOpsMin() : this.getNumMachines();
        int opsMax = this.getNumOpsMax() > 0 ? this.getNumOpsMax() : this.getNumMachines();
        double meanOps = 0.5 * (double)(opsMax + opsMin);
        double meanOpProc = this.getProcTimes().getNumericalMean();
        double jobsPerDay = this.getUtilLevel() * (double)this.getNumMachines() * 1440.0 / (meanOps * meanOpProc);
        return 1440.0 / jobsPerDay;
    }

    public double getUtilLevel() {
        return this.utilLevel;
    }

    public void setUtilLevel(double utilLevel) {
        if (utilLevel < 0.0 || utilLevel > 1.0) {
            throw new IllegalArgumentException("" + utilLevel);
        }
        this.utilLevel = utilLevel;
    }

    public DblSequence getDueDateFactor() {
        return this.dueDateFactor;
    }

    public void setDueDateFactor(DblSequence dueDateFactor) {
        this.dueDateFactor = dueDateFactor;
    }

    public int getNumMachines() {
        return this.numMachines;
    }

    public void setNumMachines(int numMachines) {
        if (numMachines < 1) {
            throw new IllegalArgumentException("" + numMachines);
        }
        this.numMachines = numMachines;
    }

    public int getNumOpsMin() {
        return (Integer)this.numOps.a;
    }

    public void setNumOpsMin(int min) {
        this.numOps = new Pair<Integer, Integer>(min, (Integer)this.numOps.b);
    }

    public int getNumOpsMax() {
        return (Integer)this.numOps.b;
    }

    public void setNumOpsMax(int max) {
        this.numOps = new Pair<Integer, Integer>((Integer)this.numOps.a, max);
    }

    public void setNumOps(int min, int max) {
        if (min < 0 || max < min) {
            throw new IllegalArgumentException("[" + min + ";" + max + "]");
        }
        this.numOps = new Pair<Integer, Integer>(min, max);
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public int getStopArrivalsAfterNumJobs() {
        return this.stopArrivalsAfterNumJobs;
    }

    public void setStopArrivalsAfterNumJobs(int stopAfterNumJobs) {
        this.stopArrivalsAfterNumJobs = stopAfterNumJobs;
    }

    public DblSequence getWeights() {
        return this.weights;
    }

    public void setWeights(DblSequence weights) {
        this.weights = weights;
    }

    public DblSequence getProcTimes() {
        return this.procTimes;
    }

    public void setProcTimes(DblSequence procTimes) {
        this.procTimes = procTimes;
    }

    public static enum Scenario {
        JOB_SHOP,
        FLOW_SHOP;

    }
}

