/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core.batchForming;

import jasima.shopSim.core.Batch;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.batchForming.BatchForming;
import java.util.List;
import java.util.Map;

public class MostCompleteBatch
extends BatchForming {
    private static final long serialVersionUID = -8735429872125881522L;
    private double maxWaitRelative;
    private double maxWait;

    public MostCompleteBatch(double maxWaitRelative) {
        this.setMaxWaitRelative(maxWaitRelative);
    }

    public MostCompleteBatch() {
        this(0.0);
    }

    public double maxProcTimeWaiting(PriorityQueue<?> q) {
        double[][] setupMatrix = this.getOwner().getSetupMatrix();
        int currSetupState = this.getOwner().currMachine.setupState;
        double res = 0.0;
        int n = q.size();
        for (int i = 0; i < n; ++i) {
            Operation o;
            double timeToComplete;
            Object j = q.get(i);
            if (((PrioRuleTarget)j).isFuture() || !((timeToComplete = setupMatrix[currSetupState][(o = ((PrioRuleTarget)j).getCurrentOperation()).getSetupState()] + o.getProcTime() + setupMatrix[o.getSetupState()][currSetupState]) > res)) continue;
            res = timeToComplete;
        }
        return res;
    }

    @Override
    public void formBatches() {
        this.maxWait = this.getMaxWaitRelative() * this.maxProcTimeWaiting(this.getOwner().queue);
        Batch b = this.efficientBatching();
        if (b == null) {
            this.defaultBatching();
        } else {
            this.possibleBatches.add(b);
        }
        assert (this.possibleBatches.size() == 1);
    }

    private Batch efficientBatching() {
        double maxRbs = 0.0;
        List<Job> maxFam = null;
        boolean tie = false;
        boolean hasIncompatible = false;
        for (List<Job> js : this.getOwner().getJobsByFamily().values()) {
            if (js.size() == 0) continue;
            Operation o = js.get(0).getCurrentOperation();
            if ("BATCH_INCOMPATIBLE".equals(o.getBatchFamily())) {
                hasIncompatible = true;
                continue;
            }
            double arriveInTimeJobs = 0.0;
            for (int i = 0; i < js.size(); ++i) {
                if (!(js.get(i).getArriveTime() - js.get(i).getShop().simTime() <= this.maxWait)) continue;
                arriveInTimeJobs += 1.0;
            }
            double rbs = Math.min(1.0, arriveInTimeJobs / (double)o.getMaxBatchSize());
            if (rbs == maxRbs) {
                tie = true;
                continue;
            }
            if (!(rbs > maxRbs)) continue;
            maxRbs = rbs;
            maxFam = js;
            tie = false;
        }
        if (!tie && !hasIncompatible) {
            Job j = (Job)maxFam.get(0);
            int mbs = j.getCurrentOperation().getMaxBatchSize();
            int arriveInTimeJobs = 0;
            for (int i = 0; i < maxFam.size(); ++i) {
                if (!(((Job)maxFam.get(i)).getArriveTime() - ((Job)maxFam.get(i)).getShop().simTime() <= this.maxWait)) continue;
                ++arriveInTimeJobs;
            }
            if (arriveInTimeJobs > mbs) {
                return null;
            }
            Batch b = new Batch(this.getOwner().shop());
            if (j.getArriveTime() - j.getShop().simTime() <= this.maxWait) {
                b.addToBatch(j);
            }
            for (int n = 1; n < maxFam.size(); ++n) {
                if (!(maxFam.get(n).getArriveTime() - maxFam.get(n).getShop().simTime() <= this.maxWait)) continue;
                b.addToBatch(maxFam.get(n));
            }
            assert ((double)b.numJobsInBatch() == maxRbs * (double)mbs);
            return b;
        }
        return null;
    }

    private void defaultBatching() {
        PriorityQueue<Job> q = this.getOwner().queue;
        this.orderedJobs = MostCompleteBatch.ensureCapacity(this.orderedJobs, q.size());
        q.getAllElementsInOrder(this.orderedJobs);
        int numJobs = q.size();
        Map<String, List<Job>> jobsByFamily = MostCompleteBatch.splitFamilies(this.orderedJobs, numJobs);
        this.formBatches(jobsByFamily);
        if (this.possibleBatches.size() > 1) {
            this.handleTiesByBasePrio(numJobs);
        }
    }

    private void formBatches(Map<String, List<Job>> jobsByFamily) {
        double maxRBS = 0.0;
        for (List<Job> famJobs : jobsByFamily.values()) {
            Operation o = famJobs.get(0).getCurrentOperation();
            if ((double)famJobs.size() < maxRBS * (double)o.getMaxBatchSize()) continue;
            if ("BATCH_INCOMPATIBLE".equals(o.getBatchFamily())) {
                for (Job j : famJobs) {
                    if (!(j.getArriveTime() - j.getShop().simTime() <= this.maxWait)) continue;
                    Batch b = new Batch(this.getOwner().shop());
                    b.addToBatch(j);
                    this.possibleBatches.add(b);
                }
                maxRBS = 1.0;
                continue;
            }
            Batch b = new Batch(this.getOwner().shop());
            for (int i = 0; i < famJobs.size() && b.numJobsInBatch() < o.getMaxBatchSize(); ++i) {
                if (!(famJobs.get(i).getArriveTime() - famJobs.get(i).getShop().simTime() <= this.maxWait)) continue;
                b.addToBatch(famJobs.get(i));
            }
            if (!(maxRBS * (double)o.getMaxBatchSize() <= (double)b.numJobsInBatch()) || 0 >= b.numJobsInBatch()) continue;
            if (maxRBS * (double)o.getMaxBatchSize() < (double)b.numJobsInBatch()) {
                this.possibleBatches.clear();
                maxRBS = (double)b.numJobsInBatch() / (double)o.getMaxBatchSize();
            }
            this.possibleBatches.add(b);
        }
    }

    private void handleTiesByBasePrio(int numJobs) {
        Batch best = (Batch)this.possibleBatches.get(0);
        int bestIdx = MostCompleteBatch.indexOf(best.job(0), this.orderedJobs, numJobs);
        int n = this.possibleBatches.size();
        for (int i = 1; i < n; ++i) {
            Batch b = (Batch)this.possibleBatches.get(i);
            int idx = MostCompleteBatch.indexOf(b.job(0), this.orderedJobs, numJobs);
            if (idx >= bestIdx) continue;
            bestIdx = idx;
            best = b;
        }
        this.possibleBatches.clear();
        this.possibleBatches.add(best);
    }

    public double getMaxWaitRelative() {
        return this.maxWaitRelative;
    }

    public void setMaxWaitRelative(double maxWaitRelative) {
        if (maxWaitRelative < 0.0 || maxWaitRelative > 1.0) {
            throw new IllegalArgumentException("maxWaitRelative " + maxWaitRelative + " has to be within [0,1]!");
        }
        this.maxWaitRelative = maxWaitRelative;
    }

    @Override
    public String getName() {
        return "MCB(" + this.getMaxWaitRelative() + ")";
    }
}

