/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core.batchForming;

import jasima.shopSim.core.Batch;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.batchForming.BatchForming;
import java.util.List;

public class HighestJobBatchingMBS
extends BatchForming {
    private static final long serialVersionUID = -1651682966642185315L;
    private double mbsRel;

    public HighestJobBatchingMBS() {
        this(0.0);
    }

    public HighestJobBatchingMBS(double mbsRel) {
        if (mbsRel < 0.0 || mbsRel > 1.0) {
            throw new IllegalArgumentException("min batch size has to be in [0.0,1.0] " + mbsRel);
        }
        this.mbsRel = mbsRel;
    }

    @Override
    public void formBatches() {
        Batch b = this.efficientBatching();
        if (b == null) {
            this.defaultBatchForming();
        } else {
            this.possibleBatches.add(b);
        }
    }

    private Batch efficientBatching() {
        PriorityQueue<Job> q = this.getOwner().queue;
        Job largest = q.peekLargest();
        Operation o = largest.getCurrentOperation();
        String bf = o.getBatchFamily();
        Batch b = new Batch(largest.getShop());
        if ("BATCH_INCOMPATIBLE".equals(o.getBatchFamily()) || o.getMaxBatchSize() == 1 || largest.isFuture()) {
            b.addToBatch(largest);
            return b;
        }
        List<Job> js = this.getOwner().getJobsByFamily().get(bf);
        int minSize = (int)Math.ceil(this.getMbsRel() * (double)o.getMaxBatchSize());
        int n = js.size();
        for (int i = 0; i < n; ++i) {
            Job j = js.get(i);
            if (j.isFuture()) continue;
            b.addToBatch(j);
        }
        assert (b.numJobsInBatch() >= 1);
        if (b.numJobsInBatch() >= minSize && b.numJobsInBatch() <= o.getMaxBatchSize()) {
            return b;
        }
        return null;
    }

    private void defaultBatchForming() {
        PriorityQueue<Job> q = this.getOwner().queue;
        this.orderedJobs = HighestJobBatchingMBS.ensureCapacity(this.orderedJobs, q.size());
        q.getAllElementsInOrder(this.orderedJobs);
        int numJobs = q.size();
        for (int i = 0; i < numJobs; ++i) {
            Job j = this.orderedJobs[i];
            if (j == null) continue;
            this.orderedJobs[i] = null;
            Operation o = j.getCurrentOperation();
            String bf = o.getBatchFamily();
            if ("BATCH_INCOMPATIBLE".equals(o.getBatchFamily()) || o.getMaxBatchSize() == 1 || j.isFuture()) {
                Batch batch = new Batch(j.getShop());
                batch.addToBatch(j);
                this.possibleBatches.add(batch);
                return;
            }
            List<Job> js = this.getOwner().getJobsByFamily().get(bf);
            int minSize = (int)Math.ceil(this.getMbsRel() * (double)o.getMaxBatchSize());
            if (js.size() < minSize) continue;
            Batch batch = new Batch(j.getShop());
            batch.addToBatch(j);
            for (int n = i + 1; n < numJobs; ++n) {
                Operation o2;
                Job j2 = this.orderedJobs[n];
                if (j2 == null || !bf.equals((o2 = j2.getCurrentOperation()).getBatchFamily())) continue;
                assert (o2.getMaxBatchSize() == o.getMaxBatchSize());
                this.orderedJobs[n] = null;
                if (!j2.isFuture()) {
                    batch.addToBatch(j2);
                }
                if (batch.numJobsInBatch() == o2.getMaxBatchSize()) break;
            }
            if (!((double)batch.numJobsInBatch() / (double)o.getMaxBatchSize() >= this.getMbsRel())) continue;
            this.possibleBatches.add(batch);
            return;
        }
    }

    @Override
    public String getName() {
        return "MBS(" + this.getMbsRel() + ")";
    }

    public double getMbsRel() {
        return this.mbsRel;
    }

    public void setMbsRel(double mbsRel) {
        this.mbsRel = mbsRel;
    }
}

