/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core.batchForming;

import jasima.shopSim.core.Batch;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.batchForming.BatchForming;
import java.util.List;
import java.util.Map;

public class BestOfFamilyBatching
extends BatchForming {
    private static final long serialVersionUID = 4249713710542519941L;

    @Override
    public void formBatches() {
        PriorityQueue<Job> q = this.getOwner().queue;
        this.orderedJobs = BestOfFamilyBatching.ensureCapacity(this.orderedJobs, q.size());
        q.getAllElementsInOrder(this.orderedJobs);
        int numJobs = q.size();
        Map<String, List<Job>> jobsByFamily = BestOfFamilyBatching.splitFamilies(this.orderedJobs, numJobs);
        for (List<Job> famJobs : jobsByFamily.values()) {
            this.formFamilyBatches(famJobs);
        }
    }

    private void formFamilyBatches(List<Job> famJobs) {
        assert (famJobs.size() > 0);
        Job j = famJobs.get(0);
        Operation o = j.getCurrentOperation();
        assert (!"BATCH_INCOMPATIBLE".equals(o.getBatchFamily()) || o.getMaxBatchSize() == 1);
        Batch b = new Batch(this.getOwner().shop());
        Batch b2 = new Batch(this.getOwner().shop());
        int n = famJobs.size();
        for (int i = 0; i < n; ++i) {
            Job job = famJobs.get(i);
            if (b.numJobsInBatch() < o.getMaxBatchSize()) {
                b.addToBatch(job);
            }
            if (!job.isFuture()) {
                b2.addToBatch(job);
            }
            if (b2.numJobsInBatch() == o.getMaxBatchSize()) break;
        }
        this.possibleBatches.add(b);
        if (b.isFuture() && b2.numJobsInBatch() > 0) {
            this.possibleBatches.add(b2);
        }
    }

    @Override
    public String getName() {
        return "BOF";
    }
}

