/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core.batchForming;

import jasima.shopSim.core.Batch;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.WorkStation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BatchForming
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6670837045346111285L;
    private WorkStation owner;
    protected PriorityQueue<Batch> possibleBatches;
    protected Job[] orderedJobs = new Job[0];

    public static int indexOf(Job j, Job[] js, int numElems) {
        int n = numElems;
        for (int i = 0; i < n; ++i) {
            if (j != js[i]) continue;
            return i;
        }
        throw new AssertionError();
    }

    public static Map<String, List<Job>> splitFamilies(Job[] jobs, int numElems) {
        HashMap<String, List<Job>> jobsPerFamily = new HashMap<String, List<Job>>();
        for (int i = 0; i < numElems; ++i) {
            Job j = jobs[i];
            String bf = j.getCurrentOperation().getBatchFamily();
            ArrayList<Job> jobsInFamily = (ArrayList<Job>)jobsPerFamily.get(bf);
            if (jobsInFamily == null) {
                jobsInFamily = new ArrayList<Job>();
                jobsPerFamily.put(bf, jobsInFamily);
            }
            jobsInFamily.add(j);
        }
        return jobsPerFamily;
    }

    public static Job[] ensureCapacity(Job[] jobs, int numElems) {
        if (jobs.length < numElems) {
            int size = Math.max(10, numElems * 5 / 4);
            return new Job[size];
        }
        return jobs;
    }

    public abstract void formBatches();

    public PrioRuleTarget nextBatch() {
        if (this.possibleBatches == null) {
            this.possibleBatches = new PriorityQueue(this.getOwner());
        } else {
            this.possibleBatches.clear();
        }
        this.possibleBatches.setSequencingRule(this.batchingRule());
        this.formBatches();
        if (this.possibleBatches.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.possibleBatches.size(); ++i) {
            Batch b = this.possibleBatches.get(i);
            this.initBatchData(b);
        }
        if (this.possibleBatches.size() == 1) {
            return this.possibleBatches.get(0);
        }
        return this.possibleBatches.peekLargest();
    }

    private PR batchingRule() {
        PR pr = this.getOwner().getBatchSequencingRule();
        return pr == null ? this.getOwner().queue.getSequencingRule() : pr;
    }

    private void initBatchData(Batch b) {
        assert (this.checkBatchData(b));
        Job job = b.job(0);
        Operation opJ = job.getCurrentOperation();
        Operation op = new Operation();
        op.setMachine(opJ.getMachine());
        op.setBatchFamily(opJ.getBatchFamily());
        op.setSetupState(opJ.getSetupState());
        op.setProcTime(opJ.getProcTime());
        op.setMaxBatchSize(opJ.getMaxBatchSize());
        b.op = op;
    }

    private boolean checkBatchData(Batch b) {
        Operation opJ = b.job(0).getCurrentOperation();
        for (int i = 1; i < b.numJobsInBatch(); ++i) {
            Operation op = b.job(i).getCurrentOperation();
            assert (opJ.getBatchFamily().equals(op.getBatchFamily()));
            assert (opJ.getMaxBatchSize() == op.getMaxBatchSize());
            assert (Math.abs(opJ.getProcTime() - op.getProcTime()) < 1.0E-6);
            assert (opJ.getSetupState() == op.getSetupState());
        }
        return true;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getName();
    }

    public BatchForming clone() {
        try {
            BatchForming bf = (BatchForming)super.clone();
            bf.possibleBatches = null;
            bf.orderedJobs = new Job[0];
            return bf;
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new AssertionError((Object)cantHappen);
        }
    }

    public WorkStation getOwner() {
        return this.owner;
    }

    public void setOwner(WorkStation o) {
        this.owner = o;
    }
}

