/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentLifecycleListener;
import jasima.shopSim.core.IndividualMachine;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.WorkStation;

public interface WorkStationListener
extends SimComponentLifecycleListener {
    @Override
    default public void inform(SimComponent o, SimComponent.SimComponentEvent event) {
        WorkStation m = (WorkStation)o;
        if (event == WorkStation.WorkStationMessage.WS_JOB_ARRIVAL) {
            this.arrival(m, m.justArrived);
        } else if (event == WorkStation.WorkStationMessage.WS_JOB_SELECTED) {
            this.operationStarted(m, m.justStarted, m.oldSetupState, m.newSetupState, m.setupTime);
        } else if (event == WorkStation.WorkStationMessage.WS_JOB_COMPLETED) {
            this.operationCompleted(m, m.justCompleted);
        } else if (event == WorkStation.WorkStationMessage.WS_ACTIVATED) {
            this.activated(m, m.currMachine);
        } else if (event == WorkStation.WorkStationMessage.WS_DEACTIVATED) {
            this.deactivated(m, m.currMachine);
        } else {
            SimComponentLifecycleListener.super.inform(o, event);
        }
    }

    default public void operationCompleted(WorkStation m, PrioRuleTarget justCompleted) {
    }

    default public void operationStarted(WorkStation m, PrioRuleTarget justStarted, int oldSetupState, int newSetupState, double setupTime) {
    }

    default public void arrival(WorkStation m, Job justArrived) {
    }

    default public void activated(WorkStation m, IndividualMachine justActivated) {
    }

    default public void deactivated(WorkStation m, IndividualMachine justDeactivated) {
    }
}

