/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentBase;
import jasima.shopSim.core.IndividualMachine;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Operation;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.batchForming.BatchForming;
import jasima.shopSim.core.batchForming.HighestJobBatchingMBS;
import jasima.shopSim.prioRules.basic.FCFS;
import jasima.shopSim.prioRules.basic.TieBreakerFASFS;
import jasima.shopSim.prioRules.meta.IgnoreFutureJobs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkStation
extends SimComponentBase {
    public static final String DEF_SETUP_STR = "DEF_SETUP";
    public static final int DEF_SETUP = 0;
    public static final String BATCH_INCOMPATIBLE = "BATCH_INCOMPATIBLE";
    public static final int LOOKAHEAD_PRIO = 0x1FFFFFFF;
    public static final int SELECT_PRIO = 0;
    public static final int DEPART_PRIO = -1073741822;
    public static final int TAKE_DOWN_PRIO = -1073740822;
    public static final int ACTIVATE_PRIO = -1073742822;
    private String name;
    private final int numInGroup;
    private final IndividualMachine[] machDat;
    private double[][] setupMatrix = new double[][]{{0.0}};
    private BatchForming batchForming;
    private PR batchSequencingRule;
    public final PriorityQueue<Job> queue;
    protected Shop shop;
    protected int index;
    private int numBusy;
    private int numFutures;
    private boolean batchingUsed;
    public IndividualMachine currMachine;
    ArrayDeque<IndividualMachine> freeMachines;
    protected double workContentReal;
    protected double workContentFuture;
    private ArrayList<String> setupStateTranslate;
    private Map<String, List<Job>> jobsPerBatchFamily;
    public Job justArrived;
    public PrioRuleTarget justStarted;
    public PrioRuleTarget justCompleted;
    public int oldSetupState;
    public int newSetupState;
    public double setupTime;

    public WorkStation() {
        this(1);
    }

    public WorkStation(int numInGroup) {
        this.numInGroup = numInGroup;
        this.numBusy = 0;
        this.queue = new PriorityQueue(this);
        FCFS sr = new FCFS();
        sr.setTieBreaker(new TieBreakerFASFS());
        sr.setOwner(this);
        this.queue.setSequencingRule(new IgnoreFutureJobs(sr));
        this.batchForming = new HighestJobBatchingMBS();
        this.batchForming.setOwner(this);
        this.machDat = new IndividualMachine[numInGroup];
        for (int i = 0; i < this.machDat.length; ++i) {
            this.machDat[i] = new IndividualMachine(this, i);
        }
    }

    @Override
    public void init() {
        super.init();
        assert (this.translateSetupState(DEF_SETUP_STR) == 0);
        this.batchingUsed = false;
        this.jobsPerBatchFamily = null;
        this.workContentReal = 0.0;
        this.workContentFuture = 0.0;
        this.freeMachines = new ArrayDeque(this.numInGroup);
        this.numBusy = 0;
        this.queue.clear();
        this.currMachine = null;
        for (int i = this.machDat.length - 1; i >= 0; --i) {
            IndividualMachine imd = this.machDat[i];
            imd.init();
            ++this.numBusy;
        }
        this.queue.getSequencingRule().init();
        if (this.getBatchSequencingRule() != null) {
            this.getBatchSequencingRule().init();
        }
    }

    void activated(IndividualMachine im) {
        assert (this.currMachine == im);
        this.freeMachines.addFirst(this.currMachine);
        --this.numBusy;
        assert (this.numBusy >= 0 && this.numBusy <= this.numInGroup);
        if (this.numJobsWaiting() > 0) {
            this.selectAndStart();
        }
        if (this.isTraceEnabled()) {
            this.trace("becomes_available", this.currMachine, this.numJobsWaiting(), this.currMachine.downReason == null ? "" : this.currMachine.downReason);
        }
        if (this.numListener() > 0) {
            this.fire(WorkStationMessage.WS_ACTIVATED);
        }
    }

    void takenDown(IndividualMachine im) {
        assert (this.currMachine == im);
        this.freeMachines.remove(this.currMachine);
        ++this.numBusy;
        assert (this.numBusy >= 0 && this.numBusy <= this.numInGroup);
        if (this.isTraceEnabled()) {
            this.trace("unavailable", this.currMachine, this.numJobsWaiting(), this.currMachine.downReason == null ? "" : this.currMachine.downReason);
        }
        if (this.numListener() > 0) {
            this.fire(WorkStationMessage.WS_DEACTIVATED);
        }
    }

    public void enqueueOrProcess(Job j) {
        assert (this == j.getCurrentOperation().getMachine());
        assert (!j.isFuture());
        if (this.numFutures > 0) {
            this.removeFromQueue(j.getMyFuture());
        }
        this.addToQueue(j, this.shop.simTime());
    }

    public void futureArrival(Job f, double arrivesAt) {
        this.getSim().scheduleAt(this.shop.simTime(), 0x1FFFFFFF, () -> this.addToQueue(f, arrivesAt));
    }

    private void addToQueue(Job j, double arrivesAt) {
        j.arriveInQueue(this, arrivesAt);
        this.queue.add(j);
        Operation o = j.getCurrentOperation();
        if (!this.batchingUsed) {
            boolean bl = this.batchingUsed = !BATCH_INCOMPATIBLE.equals(o.getBatchFamily());
        }
        if (!j.isFuture()) {
            this.workContentReal += o.getProcTime();
        } else {
            ++this.numFutures;
            this.workContentFuture += o.getProcTime();
        }
        if (this.jobsPerBatchFamily != null) {
            this.addJobToBatchFamily(j);
        }
        if (this.isTraceEnabled() && !j.isFuture()) {
            this.trace("arrives_at", j, this, this.numBusy() == 0 ? "IDLE" : "PROCESSING", this.numJobsWaiting() - 1);
        }
        if (this.numListener() > 0) {
            this.justArrived = j;
            this.fire(WorkStationMessage.WS_JOB_ARRIVAL);
            this.justArrived = null;
        }
        if (this.numBusy < this.numInGroup && this.numJobsWaiting() > 0) {
            this.selectAndStart();
        }
    }

    public void removeFromQueue(Job j) {
        boolean removeRes = this.queue.remove(j);
        j.removedFromQueue();
        if (!j.isFuture()) {
            Operation o = j.getCurrentOperation();
            this.workContentReal -= o.getProcTime();
            assert (this.workContentReal >= -1.0E-6) : "" + this.workContentReal;
            assert (removeRes);
            if (this.jobsPerBatchFamily != null) {
                this.removeJobOfBatchFamily(j, o.getBatchFamily());
            }
        } else if (removeRes) {
            Operation o = j.getOps()[j.getTaskNumber() - 1];
            this.workContentFuture -= o.getProcTime();
            assert (this.workContentFuture >= -1.0E-6) : "" + this.workContentFuture;
            --this.numFutures;
            if (this.jobsPerBatchFamily != null) {
                this.removeJobOfBatchFamily(j, o.getBatchFamily());
            }
        }
    }

    protected void startProc(PrioRuleTarget batch) {
        assert (!batch.isFuture());
        for (int i = 0; i < batch.numJobsInBatch(); ++i) {
            assert (!this.queue.contains(batch.job(i).getMyFuture()));
        }
        assert (this.numBusy < this.numInGroup);
        assert (batch.getCurrentOperation().getMachine() == this);
        assert (this.currMachine.state == IndividualMachine.MachineState.IDLE);
        double simTime = this.shop.simTime();
        this.freeMachines.remove(this.currMachine);
        for (int i = 0; i < batch.numJobsInBatch(); ++i) {
            Job job = batch.job(i);
            this.removeFromQueue(job);
        }
        ++this.numBusy;
        Operation op = batch.getCurrentOperation();
        this.oldSetupState = this.currMachine.setupState;
        this.newSetupState = op.getSetupState();
        this.setupTime = 0.0;
        if (this.oldSetupState != this.newSetupState) {
            this.setupTime = this.setupMatrix[this.oldSetupState][this.newSetupState];
            this.currMachine.setupState = this.newSetupState;
        }
        double tCompl = simTime + op.getProcTime() + this.setupTime;
        this.currMachine.onDepart.setTime(tCompl);
        this.currMachine.procFinished = tCompl;
        this.currMachine.procStarted = simTime;
        this.currMachine.curJob = batch;
        this.getSim().schedule(this.currMachine.onDepart);
        this.notifyJobsOfProcStart(batch);
        this.currMachine.state = IndividualMachine.MachineState.WORKING;
    }

    protected void notifyJobsOfProcStart(PrioRuleTarget batch) {
        for (int i = 0; i < batch.numJobsInBatch(); ++i) {
            Job j = batch.job(i);
            j.startProcessing();
        }
    }

    protected void depart() {
        assert (this.currMachine.state == IndividualMachine.MachineState.WORKING);
        PrioRuleTarget b = this.currMachine.curJob;
        this.currMachine.curJob = null;
        this.currMachine.state = IndividualMachine.MachineState.IDLE;
        this.currMachine.procFinished = -1.0;
        this.currMachine.procStarted = -1.0;
        this.freeMachines.addFirst(this.currMachine);
        --this.numBusy;
        if (this.isTraceEnabled()) {
            for (int i = 0; i < b.numJobsInBatch(); ++i) {
                this.trace("finished_processing", this.currMachine, b.job(i));
            }
        }
        if (this.numListener() > 0) {
            this.justCompleted = b;
            this.fire(WorkStationMessage.WS_JOB_COMPLETED);
            this.justCompleted = null;
        }
        this.notifyJobsOfDepart(b);
        this.currMachine = null;
        if (this.numJobsWaiting() > 0) {
            this.selectAndStart();
        }
    }

    protected void notifyJobsOfDepart(PrioRuleTarget b) {
        int n = b.numJobsInBatch();
        for (int i = 0; i < n; ++i) {
            Job j = b.job(i);
            j.endProcessing();
            j.proceed();
        }
    }

    public void selectAndStart() {
        this.getSim().scheduleAt(this.shop.simTime(), 0, this::selectAndStart0);
    }

    protected void selectAndStart0() {
        if (this.numBusy < this.numInGroup && this.numJobsWaiting() > 0) {
            PrioRuleTarget nextBatch = this.nextJobAndMachine();
            assert (this.freeMachines.contains(this.currMachine));
            if (nextBatch != null) {
                this.startProc(nextBatch);
            }
            if (this.isTraceEnabled()) {
                if (nextBatch == null) {
                    this.trace("keeping_idle", this.currMachine, nextBatch);
                } else {
                    for (int i = 0; i < nextBatch.numJobsInBatch(); ++i) {
                        this.trace("start_processing", this.currMachine, nextBatch.job(i), "", this.numJobsWaiting());
                    }
                    if (this.oldSetupState != this.newSetupState) {
                        this.trace("setup", this.currMachine, this.setupStateToString(this.oldSetupState), this.setupStateToString(this.newSetupState), this.setupTime);
                    }
                }
            }
            if (this.numListener() > 0) {
                this.justStarted = nextBatch;
                this.fire(WorkStationMessage.WS_JOB_SELECTED);
                this.justStarted = null;
            }
            this.currMachine = null;
        }
    }

    protected PrioRuleTarget nextJobAndMachine() {
        PrioRuleTarget maxJob;
        for (IndividualMachine md : this.machDat) {
            if (md.state == IndividualMachine.MachineState.IDLE) assert (this.freeMachines.contains(md));
        }
        assert (this.freeMachines.size() > 0);
        if (!this.batchingUsed) {
            this.currMachine = this.freeMachines.peekLast();
            maxJob = this.queue.peekLargest();
            if (this.freeMachines.size() > 1) {
                IndividualMachine maxMachine = this.currMachine;
                double[] maxPrio = this.queue.getBestPrios();
                if (maxPrio != null) {
                    maxPrio = (double[])maxPrio.clone();
                }
                Iterator<IndividualMachine> it = this.freeMachines.descendingIterator();
                it.next();
                while (it.hasNext()) {
                    this.currMachine = it.next();
                    Job job = this.queue.peekLargest();
                    double[] prios = this.queue.getBestPrios();
                    if (maxPrio != null && PriorityQueue.comparePrioArrays(maxPrio, prios) < 0) continue;
                    maxPrio = prios;
                    if (maxPrio != null) {
                        maxPrio = (double[])maxPrio.clone();
                    }
                    maxJob = job;
                    maxMachine = this.currMachine;
                }
                this.currMachine = maxMachine;
            }
        } else {
            this.currMachine = this.freeMachines.peekLast();
            maxJob = this.getBatchForming().nextBatch();
        }
        if (maxJob == null || maxJob.isFuture()) {
            return null;
        }
        return maxJob;
    }

    public boolean isFree(IndividualMachine im) {
        return this.freeMachines.contains(im);
    }

    public int numJobsWaiting() {
        int res = this.queue.size() - this.numFutures;
        return res;
    }

    public int numFutures() {
        return this.numFutures;
    }

    public double startedWorkInGroup() {
        double res = 0.0;
        for (int i = 0; i < this.machDat.length; ++i) {
            if (!(this.machDat[i].procFinished > this.shop.simTime())) continue;
            res += this.machDat[i].procFinished - this.shop.simTime();
        }
        return res;
    }

    public double againIdleIn() {
        assert (this.numInGroup == 1);
        return this.startedWorkInGroup();
    }

    public double againIdle() {
        return this.againIdleIn() + this.shop.simTime();
    }

    public double workContent(boolean includeFutureJobs) {
        double res = this.startedWorkInGroup() + this.workContentReal;
        if (includeFutureJobs) {
            res += this.workContentFuture;
        }
        return res / (double)this.numInGroup;
    }

    public PrioRuleTarget getProcessedJob(int machIdx) {
        return this.machDat[machIdx].curJob;
    }

    public int getSetupState(int machIdx) {
        return this.machDat[machIdx].setupState;
    }

    public void setSetupMatrix(double[][] setupMatrix) {
        this.setupMatrix = setupMatrix;
    }

    public double[][] getSetupMatrix() {
        return this.setupMatrix;
    }

    public int translateSetupState(String s) {
        int i;
        if (DEF_SETUP_STR.equals(s)) {
            return 0;
        }
        if (this.setupStateTranslate == null) {
            this.setupStateTranslate = new ArrayList();
            this.setupStateTranslate.add(DEF_SETUP_STR);
        }
        if ((i = this.setupStateTranslate.indexOf(s)) < 0) {
            i = this.setupStateTranslate.size();
            this.setupStateTranslate.add(s);
        }
        return i;
    }

    public String setupStateToString(int id) {
        if (id == 0) {
            return DEF_SETUP_STR;
        }
        if (this.setupStateTranslate != null & id >= 0 && id < this.setupStateTranslate.size()) {
            return this.setupStateTranslate.get(id);
        }
        return "sId" + id;
    }

    public int numFreeMachines() {
        return this.freeMachines.size();
    }

    public Collection<IndividualMachine> getFreeMachines() {
        return Collections.unmodifiableCollection(this.freeMachines);
    }

    public IndividualMachine[] machDat() {
        return this.machDat;
    }

    public int numBusy() {
        return this.numBusy;
    }

    public int numInGroup() {
        return this.numInGroup;
    }

    public Shop shop() {
        return this.shop;
    }

    public int index() {
        return this.index;
    }

    public Map<String, List<Job>> getJobsByFamily() {
        if (this.jobsPerBatchFamily == null) {
            this.jobsPerBatchFamily = new HashMap<String, List<Job>>();
            int n = this.queue.size();
            for (int i = 0; i < n; ++i) {
                Job j = this.queue.get(i);
                this.addJobToBatchFamily(j);
            }
        }
        return this.jobsPerBatchFamily;
    }

    private void addJobToBatchFamily(Job j) {
        String bf = j.getCurrentOperation().getBatchFamily();
        List<Job> jobsInFamily = this.jobsPerBatchFamily.get(bf);
        if (jobsInFamily == null) {
            jobsInFamily = new ArrayList<Job>();
            this.jobsPerBatchFamily.put(bf, jobsInFamily);
        }
        jobsInFamily.add(j);
    }

    private void removeJobOfBatchFamily(Job j, String bf) {
        List<Job> jobsInFamily = this.jobsPerBatchFamily.get(bf);
        boolean removeRes = jobsInFamily.remove(j);
        assert (removeRes);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public WorkStation setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? "m" + this.index : this.name;
    }

    public void setBatchForming(BatchForming formBatch) {
        this.batchForming = formBatch;
        if (formBatch != null) {
            formBatch.setOwner(this);
        }
    }

    public BatchForming getBatchForming() {
        return this.batchForming;
    }

    public void setBatchSequencingRule(PR batchSequencingRule) {
        this.batchSequencingRule = batchSequencingRule;
        if (batchSequencingRule != null) {
            batchSequencingRule.setOwner(this);
        }
    }

    public PR getBatchSequencingRule() {
        return this.batchSequencingRule;
    }

    @Override
    public WorkStation clone() {
        throw new UnsupportedOperationException("clone()");
    }

    public static enum WorkStationMessage implements SimComponent.SimComponentEvent
    {
        WS_ACTIVATED,
        WS_DEACTIVATED,
        WS_JOB_ARRIVAL,
        WS_JOB_SELECTED,
        WS_JOB_COMPLETED;

    }
}

