/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.util.Pair;
import jasima.shopSim.core.DowntimeSource;
import jasima.shopSim.core.IndividualMachine;
import jasima.shopSim.core.Shop;

public class StaticListDowntimeSource
extends DowntimeSource {
    private final Pair<Double, Double>[] data;
    private int index;

    public StaticListDowntimeSource(IndividualMachine machine, Pair<Double, Double>[] data) {
        super(machine);
        this.data = data;
    }

    @Override
    public void init() {
        this.index = -1;
        super.init();
    }

    @Override
    protected void onActivate() {
        ++this.index;
        super.onActivate();
    }

    @Override
    protected double calcDeactivateTime(Shop shop) {
        return Math.max(shop.simTime(), (Double)this.data[this.index].a);
    }

    @Override
    protected double calcActivateTime(Shop shop) {
        double duration = (Double)this.data[this.index].b - (Double)this.data[this.index].a;
        assert (duration >= 0.0);
        if (duration < 1.0E-6) {
            duration = 0.0016666666666666668;
        }
        return shop.simTime() + duration;
    }

    @Override
    protected boolean isSourceActive() {
        return this.index < this.data.length;
    }
}

