/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.shopSim.core.Job;
import jasima.shopSim.core.JobSource;

public class StaticJobSource
extends JobSource {
    public int nextJob;
    public JobSpec[] jobs;

    @Override
    public void init() {
        this.nextJob = 0;
        super.init();
    }

    @Override
    public Job createNextJob() {
        if (this.nextJob >= this.jobs.length) {
            return null;
        }
        Job j = this.newJobInstance();
        JobSpec js = this.jobs[this.nextJob];
        j.setRelDate(js.releaseDate);
        j.setDueDate(js.dueDate);
        j.setWeight(js.weight);
        j.setJobType(js.routeNum);
        j.setOps(this.getShop().routes[js.routeNum].ops());
        j.setRoute(this.getShop().routes[js.routeNum]);
        j.setName(js.name);
        ++this.nextJob;
        return j;
    }

    public static class JobSpec {
        public final int routeNum;
        public final double releaseDate;
        public final double dueDate;
        public final double weight;
        public final String name;

        public JobSpec(int routeNum, double releaseDate, double dueDate, double weight) {
            this(routeNum, releaseDate, dueDate, weight, null);
        }

        public JobSpec(int routeNum, double releaseDate, double dueDate, double weight, String name) {
            this.routeNum = routeNum;
            this.releaseDate = releaseDate;
            this.dueDate = dueDate;
            this.weight = weight;
            this.name = name;
        }
    }
}

