/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentLifecycleListener;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Shop;

public interface ShopListener
extends SimComponentLifecycleListener,
Cloneable {
    @Override
    default public void inform(SimComponent c, SimComponent.SimComponentEvent msg) {
        if (msg == Shop.ShopMessage.JOB_RELEASED) {
            Shop shop = (Shop)c;
            this.jobReleased(shop, shop.lastJobReleased);
        } else if (msg == Shop.ShopMessage.JOB_FINISHED) {
            Shop shop = (Shop)c;
            this.jobFinished(shop, shop.lastJobFinished);
        } else {
            SimComponentLifecycleListener.super.inform(c, msg);
        }
    }

    default public void jobReleased(Shop shop, Job j) {
    }

    default public void jobFinished(Shop shop, Job j) {
    }

    public ShopListener clone();
}

