/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimulationExperiment;
import jasima.core.util.TypeUtil;
import jasima.core.util.observer.NotifierListener;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.WorkStation;
import jasima.shopSim.core.batchForming.BatchForming;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public abstract class ShopExperiment
extends SimulationExperiment {
    private static final long serialVersionUID = 2660935009898060395L;
    private int maxJobsInSystem = 0;
    private int stopAfterNumJobs = 0;
    private boolean enableLookAhead = false;
    private PR sequencingRule;
    private PR batchSequencingRule;
    private BatchForming batchForming;
    private PR[] sequencingRules;
    private PR[] batchSequencingRules;
    private BatchForming[] batchFormingRules;
    private NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] shopListener;
    private NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] machineListener;
    private HashMap<String, NotifierListener<SimComponent, SimComponent.SimComponentEvent>[]> machListenerSpecific;
    protected Shop shop;

    @Override
    protected void createSimComponents() {
        super.createSimComponents();
        this.createShop();
        this.configureShop();
    }

    protected void createShop() {
        this.shop = this.doCreateShop();
        this.sim.getRootComponent().addChild(this.shop);
    }

    protected Shop doCreateShop() {
        return new Shop();
    }

    protected void configureShop() {
        this.shop.setMaxJobsInSystem(this.getMaxJobsInSystem());
        this.shop.setStopAfterNumJobs(this.getStopAfterNumJobs());
        this.shop.setEnableLookAhead(this.isEnableLookAhead());
        int n = this.shop.machines().numChildren();
        for (int i = 0; i < n; ++i) {
            BatchForming bf;
            PR br;
            WorkStation m = (WorkStation)this.shop.machines().getChild(i);
            PR sr = this.getSequencingRule(i);
            if (sr != null) {
                sr = sr.clone();
                sr.setOwner(m);
                m.queue.setSequencingRule(sr);
            }
            if ((br = this.getBatchSequencingRule(i)) != null) {
                br = br.clone();
                br.setOwner(m);
                m.setBatchSequencingRule(br);
            }
            if ((bf = this.getBatchForming(i)) == null) continue;
            bf = bf.clone();
            bf.setOwner(m);
            m.setBatchForming(bf);
        }
        if (this.shopListener != null) {
            for (NotifierListener<SimComponent, SimComponent.SimComponentEvent> l : this.shopListener) {
                NotifierListener<SimComponent, SimComponent.SimComponentEvent> c = TypeUtil.cloneIfPossible(l);
                this.shop.addListener(c);
            }
        }
        if (this.machineListener != null) {
            for (NotifierListener<SimComponent, SimComponent.SimComponentEvent> l : this.machineListener) {
                this.shop.installMachineListener(l, true);
            }
        }
        if (this.machListenerSpecific != null) {
            for (String machName : this.machListenerSpecific.keySet()) {
                NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] mls;
                WorkStation ws = this.shop.getWorkstationByName(machName);
                if (ws == null) {
                    throw new RuntimeException("Error installing machine listener: can't find a workstation named '" + machName + "'");
                }
                for (NotifierListener<SimComponent, SimComponent.SimComponentEvent> ml : mls = this.machListenerSpecific.get(machName)) {
                    ml = TypeUtil.cloneIfPossible(ml);
                    ws.addListener(ml);
                }
            }
        }
    }

    @Override
    protected void beforeRun() {
        super.beforeRun();
    }

    protected PR getSequencingRule(int i) {
        if (this.getSequencingRules() != null) {
            return this.getSequencingRules()[i];
        }
        return this.getSequencingRule();
    }

    protected PR getBatchSequencingRule(int i) {
        if (this.getBatchSequencingRules() != null) {
            return this.getBatchSequencingRules()[i];
        }
        return this.getBatchSequencingRule();
    }

    protected BatchForming getBatchForming(int i) {
        if (this.getBatchFormingRules() != null) {
            return this.getBatchFormingRules()[i];
        }
        return this.getBatchForming();
    }

    @Override
    protected void done() {
        super.done();
        int wip = this.shop.jobsStarted - this.shop.jobsFinished;
        this.aborted = this.getMaxJobsInSystem() > 0 && wip >= this.getMaxJobsInSystem() ? 1 : 0;
    }

    @Override
    protected void finish() {
        super.finish();
        this.shop = null;
    }

    @Override
    public ShopExperiment clone() {
        if (this.resultMap != null) {
            throw new IllegalStateException("Can't clone an experiment that was already executed.");
        }
        ShopExperiment clone = (ShopExperiment)super.clone();
        if (this.sequencingRule != null) {
            clone.sequencingRule = this.sequencingRule.clone();
        }
        if (this.batchSequencingRule != null) {
            clone.batchSequencingRule = this.batchSequencingRule.clone();
        }
        if (this.batchForming != null) {
            clone.batchForming = this.batchForming.clone();
        }
        clone.sequencingRules = TypeUtil.deepCloneArrayIfPossible(this.sequencingRules);
        clone.batchSequencingRules = TypeUtil.deepCloneArrayIfPossible(this.batchSequencingRules);
        clone.batchFormingRules = TypeUtil.deepCloneArrayIfPossible(this.batchFormingRules);
        clone.shopListener = TypeUtil.deepCloneArrayIfPossible(this.shopListener);
        clone.machineListener = TypeUtil.deepCloneArrayIfPossible(this.machineListener);
        if (this.machListenerSpecific != null) {
            clone.machListenerSpecific = new HashMap();
            for (String name : this.machListenerSpecific.keySet()) {
                clone.machListenerSpecific.put(name, TypeUtil.cloneIfPossible(this.machListenerSpecific.get(name)));
            }
        }
        return clone;
    }

    public void setMaxJobsInSystem(int maxJobsInSystem) {
        this.maxJobsInSystem = maxJobsInSystem;
    }

    public int getMaxJobsInSystem() {
        return this.maxJobsInSystem;
    }

    public void setEnableLookAhead(boolean enableLookAhead) {
        this.enableLookAhead = enableLookAhead;
    }

    public boolean isEnableLookAhead() {
        return this.enableLookAhead;
    }

    public void setStopAfterNumJobs(int stopAfterNumJobs) {
        this.stopAfterNumJobs = stopAfterNumJobs;
    }

    public int getStopAfterNumJobs() {
        return this.stopAfterNumJobs;
    }

    public PR getSequencingRule() {
        return this.sequencingRule;
    }

    public void setSequencingRule(PR sequencingRule) {
        this.sequencingRule = sequencingRule;
    }

    public PR getBatchSequencingRule() {
        return this.batchSequencingRule;
    }

    public void setBatchSequencingRule(PR batchSequencingRule) {
        this.batchSequencingRule = batchSequencingRule;
    }

    public BatchForming getBatchForming() {
        return this.batchForming;
    }

    public void setBatchForming(BatchForming batchForming) {
        this.batchForming = batchForming;
    }

    public void setSequencingRules(PR[] sequencingRules) {
        this.sequencingRules = sequencingRules;
    }

    public PR[] getSequencingRules() {
        return this.sequencingRules;
    }

    public void setBatchSequencingRules(PR[] batchSequencingRules) {
        this.batchSequencingRules = batchSequencingRules;
    }

    public PR[] getBatchSequencingRules() {
        return this.batchSequencingRules;
    }

    public void setBatchFormingRules(BatchForming[] batchFormingRules) {
        this.batchFormingRules = batchFormingRules;
    }

    public BatchForming[] getBatchFormingRules() {
        return this.batchFormingRules;
    }

    public NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] getShopListener() {
        return this.shopListener;
    }

    public void setShopListener(NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] shopListener) {
        this.shopListener = shopListener;
    }

    public void addShopListener(NotifierListener<SimComponent, SimComponent.SimComponentEvent> l) {
        if (this.shopListener == null) {
            NotifierListener[] resArray = new NotifierListener[]{l};
            this.shopListener = resArray;
        } else {
            ArrayList<NotifierListener<SimComponent, SimComponent.SimComponentEvent>> list = new ArrayList<NotifierListener<SimComponent, SimComponent.SimComponentEvent>>(Arrays.asList(this.shopListener));
            list.add(l);
            NotifierListener[] resArray = new NotifierListener[list.size()];
            this.shopListener = list.toArray(resArray);
        }
    }

    public NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] getMachineListener() {
        return this.machineListener;
    }

    public void setMachineListener(NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] machineListener) {
        this.machineListener = machineListener;
    }

    public void addMachineListener(NotifierListener<SimComponent, SimComponent.SimComponentEvent> l) {
        if (this.machineListener == null) {
            NotifierListener[] resArray = new NotifierListener[]{l};
            this.machineListener = resArray;
        } else {
            ArrayList<NotifierListener<SimComponent, SimComponent.SimComponentEvent>> list = new ArrayList<NotifierListener<SimComponent, SimComponent.SimComponentEvent>>(Arrays.asList(this.machineListener));
            list.add(l);
            NotifierListener[] resArray = new NotifierListener[list.size()];
            this.machineListener = list.toArray(resArray);
        }
    }

    public void addMachineListener(String name, NotifierListener<SimComponent, SimComponent.SimComponentEvent> l) {
        if (this.machListenerSpecific == null) {
            this.machListenerSpecific = new HashMap();
        }
        NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] listeners = this.machListenerSpecific.get(name);
        ArrayList<NotifierListener<SimComponent, SimComponent.SimComponentEvent>> list = new ArrayList<NotifierListener<SimComponent, SimComponent.SimComponentEvent>>();
        if (listeners != null) {
            list.addAll(Arrays.asList(listeners));
        }
        list.add(l);
        NotifierListener[] resArray = new NotifierListener[list.size()];
        this.machListenerSpecific.put(name, list.toArray(resArray));
    }

    public NotifierListener<SimComponent, SimComponent.SimComponentEvent>[] getMachineListenerSpecific(String name) {
        if (this.machListenerSpecific == null) {
            NotifierListener[] resArray = new NotifierListener[]{};
            return resArray;
        }
        return this.machListenerSpecific.get(name);
    }
}

