/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentContainer;
import jasima.core.simulation.SimComponentContainerBase;
import jasima.core.util.MsgCategory;
import jasima.core.util.TypeUtil;
import jasima.core.util.i18n.I18n;
import jasima.core.util.observer.NotifierListener;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.JobSource;
import jasima.shopSim.core.Route;
import jasima.shopSim.core.WorkStation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class Shop
extends SimComponentContainerBase {
    private int maxJobsInSystem = 0;
    private int stopAfterNumJobs = 0;
    private boolean enableLookAhead = false;
    private SimComponentContainerBase sources;
    private SimComponentContainerBase machines;
    public Route[] routes = new Route[0];
    public int jobsFinished;
    public int jobsStarted;
    public Job lastJobReleased;
    public Job lastJobFinished;

    public Shop() {
        this.sources = new SimComponentContainerBase();
        this.addChild(this.sources);
        this.machines = new SimComponentContainerBase();
        this.addChild(this.machines);
    }

    @Override
    public void init() {
        super.init();
        this.jobsFinished = 0;
        this.jobsStarted = 0;
    }

    public void jobFinished(Job j) {
        ++this.jobsFinished;
        if (this.getStopAfterNumJobs() > 0 && this.jobsFinished >= this.getStopAfterNumJobs()) {
            this.getSim().end();
        }
        j.jobFinished();
        if (this.isTraceEnabled()) {
            this.trace("leave_system", j);
        }
        this.lastJobFinished = j;
        this.fire(ShopMessage.JOB_FINISHED);
    }

    public void startJob(Job nextJob) {
        nextJob.setJobNum(this.jobsStarted++);
        if (this.getMaxJobsInSystem() > 0 && this.jobsStarted - this.jobsFinished >= this.getMaxJobsInSystem()) {
            this.getSim().print(MsgCategory.WARN, I18n.defFormat("WIP reaches %d, aborting sim.", this.getMaxJobsInSystem()));
            this.getSim().end();
        }
        nextJob.jobReleased();
        if (this.isTraceEnabled()) {
            this.trace("enter_system", nextJob);
        }
        this.lastJobReleased = nextJob;
        this.fire(ShopMessage.JOB_RELEASED);
        WorkStation mach = nextJob.getCurrentOperation().getMachine();
        mach.enqueueOrProcess(nextJob);
    }

    @Override
    public void produceResults(Map<String, Object> res) {
        super.produceResults(res);
        res.put("numJobsFinished", this.jobsFinished);
        res.put("numJobsStarted", this.jobsStarted);
        res.put("numWIP", this.jobsStarted - this.jobsFinished);
    }

    public void installMachineListener(NotifierListener<SimComponent, SimComponent.SimComponentEvent> listener, boolean cloneIfPossible) {
        for (SimComponent sc : this.machines.getChildren()) {
            WorkStation m = (WorkStation)sc;
            NotifierListener<SimComponent, SimComponent.SimComponentEvent> ml = listener;
            if (cloneIfPossible) {
                ml = TypeUtil.cloneIfPossible(ml);
            }
            m.addListener(ml);
        }
    }

    public boolean isEnableLookAhead() {
        return this.enableLookAhead;
    }

    public void setEnableLookAhead(boolean enableLookAhead) {
        this.enableLookAhead = enableLookAhead;
    }

    public void setMaxJobsInSystem(int maxJobsInSystem) {
        this.maxJobsInSystem = maxJobsInSystem;
    }

    public int getMaxJobsInSystem() {
        return this.maxJobsInSystem;
    }

    public void setStopAfterNumJobs(int stopAfterNumJobs) {
        this.stopAfterNumJobs = stopAfterNumJobs;
    }

    public int getStopAfterNumJobs() {
        return this.stopAfterNumJobs;
    }

    public JobSource[] getSources() {
        return this.sources.getChildren().toArray(new JobSource[0]);
    }

    public SimComponentContainer sources() {
        return this.sources;
    }

    public void setSources(JobSource[] sources) {
        this.sources.removeChildren();
        for (JobSource js : sources) {
            this.addJobSource(js);
        }
    }

    public void addJobSource(JobSource js) {
        js.setShop(this);
        js.index = this.sources.numChildren();
        this.sources.addChild(js);
    }

    public void removeJobSource(JobSource js) {
        if (this.sources.removeChild(js)) {
            js.setShop(null);
            js.index = -1;
            int i = 0;
            for (SimComponent sc : this.sources.getChildren()) {
                JobSource s = (JobSource)sc;
                s.index = i++;
            }
        }
    }

    public WorkStation[] getMachines() {
        return this.machines.getChildren().toArray(new WorkStation[this.machines.numChildren()]);
    }

    public SimComponentContainer machines() {
        return this.machines;
    }

    public void setMachines(WorkStation[] machines) {
        this.machines.removeChildren();
        for (WorkStation ws : machines) {
            this.addMachine(ws);
        }
    }

    public void addMachine(WorkStation machine) {
        machine.shop = this;
        machine.index = this.machines.numChildren();
        this.machines.addChild(machine);
    }

    public void removeMachine(WorkStation machine) {
        if (this.machines.removeChild(machine)) {
            machine.shop = null;
            machine.index = -1;
            int i = 0;
            for (SimComponent sc : this.machines.getChildren()) {
                WorkStation w = (WorkStation)sc;
                w.index = i++;
            }
        }
    }

    public WorkStation getWorkstationByName(String name) {
        WorkStation res = null;
        if (this.getMachines() != null) {
            for (WorkStation w : this.getMachines()) {
                if (!name.equals(w.getName())) continue;
                res = w;
                break;
            }
        }
        return res;
    }

    public Route[] getRoutes() {
        return this.routes;
    }

    public void setRoutes(Route[] routes) {
        this.routes = (Route[])routes.clone();
    }

    public void addRoute(Route r) {
        ArrayList<Route> list = new ArrayList<Route>(Arrays.asList(this.routes));
        list.add(r);
        this.routes = list.toArray(new Route[list.size()]);
    }

    public void removeRoute(Route r) {
        ArrayList<Route> list = new ArrayList<Route>(Arrays.asList(this.routes));
        if (list.remove(r)) {
            this.routes = list.toArray(new Route[list.size()]);
        }
    }

    @Override
    public Shop clone() {
        throw new UnsupportedOperationException("clone()");
    }

    public static enum ShopMessage implements SimComponent.SimComponentEvent
    {
        JOB_RELEASED,
        JOB_FINISHED;

    }
}

