/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.util.MsgCategory;
import jasima.shopSim.core.PR;
import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.WorkStation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class PriorityQueue<T extends PrioRuleTarget>
implements Serializable {
    private static final long serialVersionUID = -4159482968254168459L;
    public static final double MAX_PRIO = Double.MAX_VALUE;
    public static final double MIN_PRIO = -1.7976931348623157E308;
    private final Comparator<ListEntry<T>> comparator;
    protected ListEntry<T>[] nodes_;
    protected int count_ = 0;
    private ListEntry<T> reuse;
    private PR sr;
    private PR[] rules = new PR[0];
    private double[] bestPrios;
    private final WorkStation workStation;

    public static int comparePrioArrays(double[] p1, double[] p2) {
        for (int i = 0; i < p1.length; ++i) {
            int cmpRes = PriorityQueue.compareValues(p1[i], p2[i]);
            if (cmpRes == 0) continue;
            return cmpRes;
        }
        return 0;
    }

    public static int compareValues(double v1, double v2) {
        if (v1 == 0.0 && v2 == 0.0) {
            return 0;
        }
        return -Double.compare(v1, v2);
    }

    public PriorityQueue(WorkStation workStation) {
        this.workStation = workStation;
        ListEntry[] array = new ListEntry[11];
        this.nodes_ = array;
        this.comparator = new ComparatorImpl<T>();
    }

    public int size() {
        return this.count_;
    }

    public void add(T elem) {
        ListEntry<T> e;
        if (this.reuse != null) {
            e = this.reuse;
            this.reuse = this.reuse.next;
        } else {
            e = new ListEntry(this.rules.length);
        }
        e.elem = elem;
        if (this.count_ >= this.nodes_.length) {
            this.setCapacity(3 * this.nodes_.length / 2 + 1);
        }
        this.nodes_[this.count_++] = e;
    }

    public T removeLargest() {
        PrioRuleTarget res = null;
        this.bestPrios = null;
        int minIdx = this.updatePrios();
        if (minIdx >= 0) {
            ListEntry<T> entry = this.nodes_[minIdx];
            this.nodes_[minIdx] = this.nodes_[--this.count_];
            this.nodes_[this.count_] = null;
            res = (PrioRuleTarget)entry.elem;
            this.bestPrios = entry.prios;
            this.recycle(entry);
        }
        return (T)res;
    }

    public T peekLargest() {
        PrioRuleTarget res = null;
        this.bestPrios = null;
        int minIdx = this.updatePrios();
        if (minIdx >= 0) {
            ListEntry<T> minEntry = this.nodes_[minIdx];
            this.bestPrios = minEntry.prios;
            res = (PrioRuleTarget)minEntry.elem;
        }
        return (T)res;
    }

    public T[] getAllElementsInOrder(T[] resArray) {
        if (resArray == null) {
            throw new IllegalArgumentException();
        }
        if (this.count_ == 0) {
            return resArray;
        }
        int minIdx = this.updatePrios();
        ListEntry<T> min = this.nodes_[minIdx];
        Arrays.sort(this.nodes_, 0, this.count_, this.comparator);
        assert (this.comparator.compare(this.nodes_[0], min) == 0);
        int n = Math.min(resArray.length, this.count_);
        for (int i = 0; i < n; ++i) {
            resArray[i] = (PrioRuleTarget)this.nodes_[i].elem;
        }
        return resArray;
    }

    public <C extends Collection<T>> C getAllElements(C c) {
        int n = this.count_;
        for (int i = 0; i < n; ++i) {
            c.add((PrioRuleTarget)((PrioRuleTarget)this.nodes_[i].elem));
        }
        return c;
    }

    public T get(int i) {
        return (T)((PrioRuleTarget)this.nodes_[i].elem);
    }

    public boolean remove(T o) {
        for (int i = 0; i < this.count_; ++i) {
            if (o != this.nodes_[i].elem) continue;
            ListEntry<T> entry = this.nodes_[i];
            this.nodes_[i] = this.nodes_[--this.count_];
            this.nodes_[this.count_] = null;
            this.recycle(entry);
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.count_; ++i) {
            ListEntry<T> entry = this.nodes_[i];
            this.nodes_[i] = null;
            this.recycle(entry);
        }
        this.count_ = 0;
    }

    public boolean contains(T o) {
        for (int i = 0; i < this.count_; ++i) {
            if (o != this.nodes_[i].elem) continue;
            return true;
        }
        return false;
    }

    private void recycle(ListEntry<T> entry) {
        entry.elem = null;
        entry.next = this.reuse;
        this.reuse = entry;
    }

    public void setSequencingRule(PR sr) {
        if (this.sr == sr) {
            return;
        }
        this.sr = sr;
        int oldRuleCount = this.rules.length;
        this.rules = new PR[this.dimCount(sr)];
        int i = 0;
        do {
            this.rules[i++] = sr;
        } while ((sr = sr.getTieBreaker()) != null);
        this.reuse = null;
        if (oldRuleCount != this.rules.length) {
            for (int j = 0; j < this.nodes_.length; ++j) {
                ListEntry<T> e = this.nodes_[j];
                if (e == null) continue;
                ListEntry le = new ListEntry(this.rules.length);
                le.elem = e.elem;
                this.nodes_[j] = le;
            }
        }
    }

    public PR getSequencingRule() {
        return this.sr;
    }

    protected int capacity() {
        return this.nodes_.length;
    }

    protected void setCapacity(int newCap) {
        ListEntry[] newnodes = new ListEntry[newCap];
        System.arraycopy(this.nodes_, 0, newnodes, 0, this.count_);
        this.nodes_ = newnodes;
    }

    private int updatePrios() {
        if (this.count_ == 0) {
            return -1;
        }
        if (this.rules.length == 0) {
            assert (this.sr == null);
            return -1;
        }
        for (PR rule : this.rules) {
            rule.beforeCalc(this);
            if (!rule.keepIdle()) continue;
            return -1;
        }
        this.updatePrio(this.nodes_[0]);
        ListEntry<T> minEntry = this.nodes_[0];
        int minIdx = 0;
        int n = this.count_;
        for (int i = 1; i < n; ++i) {
            ListEntry<T> le = this.nodes_[i];
            this.updatePrio(le);
            if (this.comparator.compare(minEntry, le) <= 0) continue;
            minEntry = le;
            minIdx = i;
        }
        return minIdx;
    }

    private void updatePrio(ListEntry<T> le) {
        double[] vs = le.prios;
        assert (vs.length == this.rules.length);
        for (int j = 0; j < vs.length; ++j) {
            vs[j] = this.rules[j].calcPrio((PrioRuleTarget)le.elem);
        }
    }

    private int dimCount(PR sr) {
        int dims = 0;
        while (sr != null) {
            ++dims;
            sr = sr.getTieBreaker();
        }
        return dims;
    }

    public double[] getBestPrios() {
        return this.bestPrios;
    }

    public WorkStation getWorkStation() {
        return this.workStation;
    }

    private static class ListEntry<T> {
        public T elem;
        public final double[] prios;
        public ListEntry<T> next;

        public ListEntry(int numPrios) {
            this.prios = new double[numPrios];
        }
    }

    private final class ComparatorImpl<O extends PrioRuleTarget>
    implements Comparator<ListEntry<O>>,
    Serializable {
        private static final long serialVersionUID = -6907667564606558578L;

        private ComparatorImpl() {
        }

        @Override
        public int compare(ListEntry<O> i1, ListEntry<O> i2) {
            if (i1 == i2) {
                return 0;
            }
            double[] p1 = i1.prios;
            double[] p2 = i2.prios;
            int res = PriorityQueue.comparePrioArrays(p1, p2);
            if (res == 0) {
                PriorityQueue.this.getWorkStation().getSim().print(MsgCategory.WARN, "equal priorities.");
            }
            return res;
        }
    }
}

