/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.shopSim.core.PrioRuleTarget;
import jasima.shopSim.core.PriorityQueue;
import jasima.shopSim.core.WorkStation;
import jasima.shopSim.prioRules.meta.LookaheadThreshold;
import java.io.Serializable;

public abstract class PR
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -880043612686550471L;
    public static final double MIN_PRIO = -1.7976931348623157E308;
    public static final double MAX_PRIO = Double.MAX_VALUE;
    private WorkStation owner;
    private PR tieBreaker;
    private PR primaryRule;
    private LookaheadThreshold firstLookaheadRule = null;
    private boolean lookaheadRuleValid = false;

    public void init() {
        if (this.getTieBreaker() != null) {
            this.getTieBreaker().init();
        }
    }

    public void beforeCalc(PriorityQueue<? extends PrioRuleTarget> q) {
    }

    public abstract double calcPrio(PrioRuleTarget var1);

    public boolean keepIdle() {
        return false;
    }

    public final String toString() {
        String res = this.getName();
        if (this.getTieBreaker() != null) {
            return res + "[" + this.getTieBreaker().toString() + "]";
        }
        return res;
    }

    public String getName() {
        String res = this.getClass().getSimpleName();
        if (res.isEmpty()) {
            res = this.getClass().getName();
        }
        return res;
    }

    public PR clone() {
        try {
            PR clone = (PR)super.clone();
            clone.firstLookaheadRule = null;
            clone.lookaheadRuleValid = false;
            if (this.getTieBreaker() != null) {
                clone.tieBreaker = null;
                clone.setTieBreaker(this.getTieBreaker().clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new AssertionError((Object)cantHappen);
        }
    }

    public WorkStation getOwner() {
        return this.owner;
    }

    public PR setOwner(WorkStation o) {
        this.owner = o;
        if (this.getTieBreaker() != null) {
            this.getTieBreaker().setOwner(o);
        }
        return this;
    }

    public void setTieBreaker(PR tieBreaker) {
        if (this.tieBreaker != null) {
            this.tieBreaker.primaryRule = null;
        }
        this.tieBreaker = tieBreaker;
        if (tieBreaker != null) {
            tieBreaker.primaryRule = this;
            tieBreaker.setOwner(this.getOwner());
        }
    }

    public PR setFinalTieBreaker(PR tieBreaker) {
        PR pr = this;
        while (pr.getTieBreaker() != null) {
            pr = pr.getTieBreaker();
        }
        pr.setTieBreaker(tieBreaker);
        return this;
    }

    public PR getTieBreaker() {
        return this.tieBreaker;
    }

    public PR primaryRule() {
        return this.primaryRule;
    }

    public boolean arrivesTooLate(PrioRuleTarget j) {
        if (!this.lookaheadRuleValid) {
            this.firstLookaheadRule = null;
            for (PR own = this.primaryRule(); own != null; own = own.primaryRule()) {
                if (!(own instanceof LookaheadThreshold)) continue;
                this.firstLookaheadRule = (LookaheadThreshold)own;
            }
            this.lookaheadRuleValid = true;
        }
        if (this.firstLookaheadRule != null) {
            return this.firstLookaheadRule.arrivesTooLate(j);
        }
        return false;
    }
}

