/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.simulation.SimComponentBase;
import jasima.core.simulation.SimEvent;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Shop;

public abstract class JobSource
extends SimComponentBase {
    public static final int ARRIVE_PRIO = -536870911;
    private Shop shop;
    public boolean stopArrivals;
    public int jobsStarted;
    public int index;

    @Override
    public void init() {
        super.init();
        this.stopArrivals = false;
        this.jobsStarted = 0;
        SimEvent arriveEvent = new SimEvent(0.0, -536870911){
            private Job nextJob;

            @Override
            public void handle() {
                if (JobSource.this.stopArrivals) {
                    return;
                }
                Job job = JobSource.this.createNextJob();
                if (job != null) {
                    if (job.getRelDate() < JobSource.this.simTime()) {
                        throw new IllegalStateException("arrival time is in the past: " + job);
                    }
                    this.setTime(job.getRelDate());
                    JobSource.this.getSim().schedule(this);
                }
                if (this.nextJob != null) {
                    JobSource.this.getShop().startJob(this.nextJob);
                }
                this.nextJob = job;
            }
        };
        arriveEvent.setTime(this.simTime());
        this.getSim().schedule(arriveEvent);
    }

    public abstract Job createNextJob();

    protected Job newJobInstance() {
        return new Job(this.getShop());
    }

    public Shop getShop() {
        return this.shop;
    }

    public void setShop(Shop shop) {
        this.shop = shop;
    }

    @Override
    public JobSource clone() {
        JobSource s = (JobSource)super.clone();
        return s;
    }
}

