/*
 * Decompiled with CFR 0.152.
 */
package jasima.shopSim.core;

import jasima.core.util.observer.NotifierListener;
import jasima.shopSim.core.Job;
import jasima.shopSim.core.Shop;
import jasima.shopSim.core.WorkStation;

public interface JobListener
extends NotifierListener<Job, Job.JobEvent> {
    @Override
    default public void inform(Job o, Job.JobEvent event) {
        Shop shop = o.getShop();
        if (event == Job.JobMessage.JOB_RELEASED) {
            this.released(shop, o);
        } else if (event == Job.JobMessage.JOB_FINISHED) {
            this.finished(shop, o);
        } else if (event == Job.JobMessage.JOB_ARRIVED_IN_QUEUE) {
            this.arrivedInQueue(shop, o);
        } else if (event == Job.JobMessage.JOB_REMOVED_FROM_QUEUE) {
            this.removedFromQueue(shop, o);
        } else if (event == Job.JobMessage.JOB_START_OPERATION) {
            WorkStation m = o.getCurrMachine();
            this.operationStarted(shop, o, m.oldSetupState, m.newSetupState, m.setupTime);
        } else if (event == Job.JobMessage.JOB_END_OPERATION) {
            this.endOperation(shop, o);
        } else {
            this.handleOther(shop, o, event);
        }
    }

    default public void handleOther(Shop shop, Job j, Object event) {
    }

    default public void endOperation(Shop shop, Job j) {
    }

    default public void operationStarted(Shop shop, Job j, int oldSetupState, int newSetupState, double setupTime) {
    }

    default public void removedFromQueue(Shop shop, Job j) {
    }

    default public void arrivedInQueue(Shop shop, Job j) {
    }

    default public void finished(Shop shop, Job j) {
    }

    default public void released(Shop shop, Job j) {
    }

    @FunctionalInterface
    public static interface ReleasedListener
    extends JobListener {
        @Override
        public void released(Shop var1, Job var2);
    }

    @FunctionalInterface
    public static interface FinishedListener
    extends JobListener {
        @Override
        public void finished(Shop var1, Job var2);
    }

    @FunctionalInterface
    public static interface ArrivedListener
    extends JobListener {
        @Override
        public void arrivedInQueue(Shop var1, Job var2);
    }

    @FunctionalInterface
    public static interface RemovedListener
    extends JobListener {
        @Override
        public void removedFromQueue(Shop var1, Job var2);
    }

    @FunctionalInterface
    public static interface OperationStartedListener
    extends JobListener {
        @Override
        public void operationStarted(Shop var1, Job var2, int var3, int var4, double var5);
    }

    @FunctionalInterface
    public static interface OperationEndedListener
    extends JobListener {
        @Override
        public void endOperation(Shop var1, Job var2);
    }

    @FunctionalInterface
    public static interface OtherListener
    extends JobListener {
        @Override
        public void handleOther(Shop var1, Job var2, Object var3);
    }
}

